//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <Wt/WApplication>
#include <Wt/WTimer>
//---------------------------------------------------------------------------
#include "administratordialog.h"
#include "administratordialogstateloggedin.h"
#include "administratordialogstatenotloggedin.h"
#include "groups.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "logfile.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "stopwatch.h"
//---------------------------------------------------------------------------
AdministratorDialog::AdministratorDialog()
  : m_state(0),
    m_state_logged_in(new AdministratorDialogStateLoggedIn(this)),
    m_state_not_logged_in(new AdministratorDialogStateNotLoggedIn(this)),
    m_timer(new Wt::WTimer)
{
  assert(!m_state);
  assert(m_state_logged_in);
  assert(m_state_not_logged_in);
  assert(Wt::WApplication::instance()->updatesEnabled());
  SetState(GetStateNotLoggedIn());

  m_timer->timeout().connect(this,&AdministratorDialog::OnTimer);
  m_timer->setInterval(Server::m_poll_time);
  m_timer->start();
}
//---------------------------------------------------------------------------
AdministratorDialog::~AdministratorDialog()
{
  assert(m_timer);
  //m_timer->stop();
}
//---------------------------------------------------------------------------
bool AdministratorDialog::CanGetAdministrator() const
{
  assert(m_administrator.empty() || m_administrator.size() == 1);
  return !m_administrator.empty();
}
//---------------------------------------------------------------------------
boost::shared_ptr<Administrator> AdministratorDialog::GetAdministrator() const
{
  assert(CanGetAdministrator());
  assert(m_administrator.size() == 1);
  return m_administrator[0];
}
//---------------------------------------------------------------------------
AdministratorDialogStateLoggedIn * AdministratorDialog::GetStateLoggedIn() const
{
  assert(m_state_logged_in);
  return m_state_logged_in.get();
}
//---------------------------------------------------------------------------
AdministratorDialogStateNotLoggedIn * AdministratorDialog::GetStateNotLoggedIn() const
{
  assert(m_state_not_logged_in);
  return m_state_not_logged_in.get();
}
//---------------------------------------------------------------------------
void AdministratorDialog::SetState(AdministratorDialogState * const state)
{
  assert(state);
  m_state = state;
  assert(m_state);
  m_state->ShowPage();
}
//---------------------------------------------------------------------------
//void AdministratorDialog::StartTimer()
//{
//  m_timer->start();
//}
//---------------------------------------------------------------------------
//void AdministratorDialog::StopTimer()
//{
//  m_timer->stop();
//}
//---------------------------------------------------------------------------
//void AdministratorDialog::OnServerTimer()
//{
//  //std::clog << "WtAdminstratorDialog::OnServerTimer()\n";
//  //assert(m_state);
//  //m_state->OnTimer();
//}
//---------------------------------------------------------------------------
void AdministratorDialog::OnTimer()
{
  //OnServerTimer();
  this->m_state->OnTimer();
}
//---------------------------------------------------------------------------
void AdministratorDialog::SetAdministrator(boost::shared_ptr<Administrator> administrator)
{
  assert(m_administrator.empty());
  m_administrator.push_back(administrator);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
