//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <fstream>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/filesystem.hpp>
#include <boost/regex.hpp>
//---------------------------------------------------------------------------
#include "stopwatch.h" //In the precompiled header
//---------------------------------------------------------------------------
#include "administrator.h"
//#include "chatmessage.h"
//#include "state.h"
//#include "logfile.h"
//#include "parameters.h"
//#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
//#include "participant.h"
//#include "repeatassigner.h"
//#include "server.h"
//#include "serverstate.h"
//#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstateviewresultsgroup.h"
#include "serverstatewaiting.h"
#include "administratordialog.h"
#include "administratordialogstate.h"
//---------------------------------------------------------------------------
AdministratorDialogState::AdministratorDialogState(
  AdministratorDialog * const dialog)
  : m_dialog(dialog)
{
  assert(m_dialog);
}
//---------------------------------------------------------------------------
///FileExists checks if a certain file exists
///From http://www.richelbilderbeek.nl/CppFileExists.htm
bool AdministratorDialogState::FileExists(const std::string& filename)
{
  std::fstream f;
  f.open(filename.c_str(),std::ios::in);
  return f.is_open();
}
//---------------------------------------------------------------------------
///FileToVector reads a file and converts it to a std::vector<std::string>
///From http://www.richelbilderbeek.nl/CppFileToVector.htm
const std::vector<std::string> AdministratorDialogState::FileToVector(const std::string& filename)
{
  assert(FileExists(filename));
  std::vector<std::string> v;
  std::ifstream in(filename.c_str());
  std::string s;
  for (int i=0; !in.eof(); ++i)
  {
    std::getline(in,s);
    v.push_back(s);
  }
  return v;
}
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/CppGetFilesInFolder.htm
const std::vector<std::string> AdministratorDialogState::GetFilesInFolder(const std::string& folder)
{
  std::vector<std::string> v;

  const boost::filesystem::path my_folder
    = boost::filesystem::system_complete(
        boost::filesystem::path(folder));

  if (!boost::filesystem::is_directory(my_folder)) return v;

  const boost::filesystem::directory_iterator j;
  for ( boost::filesystem::directory_iterator i(my_folder);
        i != j;
        ++i)
  {
    if ( boost::filesystem::is_regular_file( i->status() ) )
    {
      const std::string filename = i->path().filename();
      //const std::string full_filename = folder + "/" + filename;
      v.push_back(filename);
    }
  }
  return v;
}
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/CppGetTextFilesInFolder.htm
const std::vector<std::string> AdministratorDialogState::GetTextFilesInFolder(const std::string& folder)
{
  //Get all filenames
  const std::vector<std::string> v = GetFilesInFolder(folder);

  //Create the regex for a text file
  const boost::regex txt_file_regex(".*\\.txt\\z");

  //Create the resulting std::vector
  std::vector<std::string> w;

  //Copy all filenames matching the regex in the resulting std::vector
  BOOST_FOREACH(const std::string& s, v)
  {
    if (boost::regex_match(s,txt_file_regex)) w.push_back(s);
  }

  return w;
}
//---------------------------------------------------------------------------
bool AdministratorDialogState::IsLoggedIn() const
{
  assert(GetDialog() && "Assume the parent can be read");
  return GetDialog()->CanGetAdministrator();
}
//---------------------------------------------------------------------------
