//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#ifndef ADMINISTRATORDIALOGSTATELOGGEDIN_H
#define ADMINISTRATORDIALOGSTATELOGGEDIN_H
//---------------------------------------------------------------------------
#include "administratordialogstate.h"
#include "forward_declarations.h"
//---------------------------------------------------------------------------
///\brief
///The WtAdministratorDialog its state for a logged in Administrator
struct AdministratorDialogStateLoggedIn : public AdministratorDialogState
{
  ///This AdministratorDialogState its AdministratorDialog
  AdministratorDialogStateLoggedIn(AdministratorDialog * const dialog);

  ///Respond to timer
  void OnTimer();

  ///Show this AdministratorDialogState its page
  void ShowPage();

  private:
  ///Only allow a Boost smart pointer to delete AdministratorDialogStateLoggedIn
  //to prevent the following trouble,
  //cited from http://www.boost.org/libs/utility/checked_delete.html:
  //The C++ StandardParticipantDialogState allows, in 5.3.5/5, pointers to incomplete
  //class types to be deleted with a delete-expression.
  //When the class has a non-trivial destructor, or a class-specific operator
  //delete, the behavior is undefined. Some compilers issue a warning when an
  //incomplete type is deleted, but unfortunately, not all do, and programmers
  //sometimes ignore or disable warnings.
  ~AdministratorDialogStateLoggedIn() {}
  ///Only allow a Boost smart pointer to delete AdministratorDialogStateLoggedIn
  //Template syntax from Herb Sutter. Exceptional C++ style. 2005. ISBN: 0-201-76042-8. Item 8: 'Befriending templates'.
  friend void boost::checked_delete<>(AdministratorDialogStateLoggedIn* x);

  Wt::WButtonGroup * m_button_group_set_phase;
  WtGroupWidget * m_group_widget;
  Wt::WFileUpload * m_fileupload;
  Wt::WLabel * m_label_state_server;
  Wt::WLabel * m_label_state_upload;
  //Wt::WTextArea * m_text_chat;
  Wt::WTextArea * m_text_groups;
  Wt::WTextArea * m_text_parameter_file;
  Wt::WTextArea * m_text_participants;
  Wt::WTextArea * m_text_server;

  Wt::WContainerWidget * CreateManipulateExperimentDialog();
  Wt::WContainerWidget * CreateStartExperimentDialog();
  //Wt::WContainerWidget * CreateViewChatDialog();
  Wt::WContainerWidget * CreateViewGroupsDialog();
  Wt::WContainerWidget * CreateViewParametersDialog();
  Wt::WContainerWidget * CreateViewParticipantsDialog();
  Wt::WContainerWidget * CreateViewServerDialog();

  const std::vector<std::vector<int> > ExtractIds() const;
  //void OnClearFiles();
  void OnClearLogFile();
  void OnDeleteParticipants();
  void OnSetExperimentState();
  //void OnStartDefaultExperiment();
  void OnUploadDone();
  void OnViewLogFile();
  //void OnViewServerFilenames();

  static const std::vector<std::string> XmlToPretty(const std::string& s);
  static const std::vector<std::string> SplitXml(const std::string& s);

};
//---------------------------------------------------------------------------
#endif // ADMINISTRATORDIALOGSTATELOGGEDIN_H
