//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WLabel>
#include <Wt/WLineEdit>
//---------------------------------------------------------------------------
#include "administratordialog.h"
#include "administratordialogstateloggedin.h"
#include "administratordialogstatenotloggedin.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "logfile.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "stopwatch.h"
//---------------------------------------------------------------------------
AdministratorDialogStateNotLoggedIn::AdministratorDialogStateNotLoggedIn(
  AdministratorDialog * const dialog)
  : AdministratorDialogState(dialog),
    m_edit_password(0),
    m_label_password(0)
{

}
//---------------------------------------------------------------------------
void AdministratorDialogStateNotLoggedIn::OnPassword()
{
  assert(!GetDialog()->CanGetAdministrator() && "Assume no administrator yet");
  //Theoretical Biology beats COCON
  //at a Pub Quiz 4 ever
  const std::string password = "TBbCaaPQ4e";
  if (m_edit_password->text().toUTF8() == password)
  {
    //Add the Administrator
    GetDialog()->SetAdministrator(Server::Get()->LoginAdministrator());
    assert(GetDialog()->CanGetAdministrator() && "Assume one administrator");

    GetDialog()->SetState(GetDialog()->GetStateLoggedIn());
  }
}
//---------------------------------------------------------------------------
void AdministratorDialogStateNotLoggedIn::OnTimer()
{
  //Do exactly nothing...
}
//---------------------------------------------------------------------------
void AdministratorDialogStateNotLoggedIn::ShowPage()
{
  AdministratorDialog * const dialog = GetDialog();
  assert(dialog);

  //dialog->StopTimer();

  dialog->clear(); //Wt deletes all dialog's child widgets

  m_edit_password = new Wt::WLineEdit;
  m_label_password = new Wt::WLabel("Password");

  dialog->setContentAlignment(Wt::AlignCenter);
  dialog->addWidget(new Wt::WBreak);
  new Wt::WLabel("Welcome potential administrator",dialog);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_password);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_edit_password);

  m_edit_password->setMinimumSize(300,Wt::WLength::Auto);
  m_edit_password->setEchoMode(Wt::WLineEdit::Password);
  #ifndef NDEBUG
  m_edit_password->setText("TBbCaaPQ4e");
  #endif
  m_edit_password->enterPressed().connect(
    this,&AdministratorDialogStateNotLoggedIn::OnPassword);

}
//---------------------------------------------------------------------------
