//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
//---------------------------------------------------------------------------
#include "chooseactionoption.h"
//---------------------------------------------------------------------------
ChooseActionOption::ChooseActionOption(
  const double contribution,
  const double cost,
  const std::string& description)
{
  SetContribution(contribution);
  SetCost(cost);
  SetDescription(description);
}
//---------------------------------------------------------------------------
///Get the chance of getting caught by a supervisor when not contributing
double ChooseActionOption::GetContribution() const
{
  return m_contribution;
}
//---------------------------------------------------------------------------
///Get the cost of this supervisor/option
double ChooseActionOption::GetCost() const
{
  return m_cost;
}
//---------------------------------------------------------------------------
///Get the description of this voting option
const std::string& ChooseActionOption::GetDescription() const
{
  return m_description;
}
//---------------------------------------------------------------------------
///Set the chance of getting caught by a supervisor when not contributing
void ChooseActionOption::SetContribution(const double contribution)
{
  m_contribution = contribution;
}
//---------------------------------------------------------------------------
///Set the cost of this supervisor/option
void ChooseActionOption::SetCost(const double cost)
{
  assert(cost >= 0.0 && "Costs typically are positive values");
  m_cost = cost;
}
//---------------------------------------------------------------------------
///Set the description of this voting option
void ChooseActionOption::SetDescription(const std::string& description)
{
  assert(!description.empty() && "A description must contain text");
  m_description = description;
}
//---------------------------------------------------------------------------
std::ostream& operator<<(std::ostream& os,const ChooseActionOption& v)
{
  os
    << "<contribution>"
    << v.GetContribution()
    << "</contribution>"
    << "<cost>"
    << v.GetCost()
    << "</cost>"
    << "<description>"
    << v.GetDescription()
    << "</description>";
  return os;
}
//---------------------------------------------------------------------------




