//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WFileUpload>
#include <Wt/WLabel>
#include <Wt/WTimer>
//---------------------------------------------------------------------------
#include "debugdialog.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "ipaddress.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participantdialog.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "stopwatch.h"
//---------------------------------------------------------------------------
DebugDialog::DebugDialog()
  : m_fileupload(0),
    m_label_state_upload(0),
    m_timer(new Wt::WTimer(this))
{
  assert(m_timer);

  Show();

  m_timer->timeout().connect(this,&DebugDialog::OnTimer);
  assert(Server::m_poll_time > 0);
  m_timer->setInterval(Server::m_poll_time);
  m_timer->start();
}
//---------------------------------------------------------------------------
DebugDialog::~DebugDialog()
{
  assert(m_timer);
  m_timer->stop();
}
//---------------------------------------------------------------------------
///Do something random to the dialog
void DebugDialog::OnTimer()
{
  BOOST_FOREACH(ParticipantDialog* dialog,m_dialogs)
  {
    dialog->DoSomethingRandom();
  }
}
//---------------------------------------------------------------------------
void DebugDialog::OnUploadDone()
{
  boost::shared_ptr<Parameters> parameters(new Parameters);
  assert(parameters);
  try
  {
    parameters->ReadFromFile(m_fileupload->spoolFileName());
  }
  catch (std::runtime_error& e)
  {
    m_label_state_upload->setText(e.what());
    return;
  }

  m_label_state_upload->setText("OK: parameter file loaded");
  Server::Get()->Reset();
  Server::Get()->SetParameters(parameters);

  //Create the Participant dialogs

  ///Remove all ParticipantDialogs from Wt::WContainerWidget and std::vector
  this->clear();
  m_dialogs.resize(0);

  const int n_participants = Server::Get()->GetGroups()->CollectParticipants().size();
  for (int i=0; i!=n_participants; ++i)
  {
    std::string ip_address_str
      = "000.000.000."
      + boost::lexical_cast<std::string>(i);
    boost::scoped_ptr<SafeIpAddress> ip_address(
      new SafeIpAddress(ip_address_str));
    ParticipantDialog* const dialog = new ParticipantDialog(ip_address.get());
    m_dialogs.push_back(dialog);
    addWidget(dialog);
  }
}
//---------------------------------------------------------------------------
void DebugDialog::Show()
{
  this->clear();

  m_fileupload = new Wt::WFileUpload;
  m_label_state_upload = new Wt::WLabel;

  assert(m_fileupload);
  assert(m_label_state_upload);

  setContentAlignment(Wt::AlignCenter);
  new Wt::WBreak(this);
  addWidget(m_label_state_upload);
  new Wt::WBreak(this);
  new Wt::WBreak(this);
  addWidget(m_fileupload);

  m_label_state_upload->setText("Please select a file to upload or press the button");

  //Upload automatically when the user entered a file
  m_fileupload->changed().connect(
    m_fileupload,
    &Wt::WFileUpload::upload);

  //Call OnUploadDone when file is uploaded
  m_fileupload->uploaded().connect(
    this,
    &DebugDialog::OnUploadDone);
}
//---------------------------------------------------------------------------
