//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <fstream>
//---------------------------------------------------------------------------
#include "group.h"
#include "logfile.h"
#include "state.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "participantdialogstate.h"
#include "stopwatch.h"
#include "serverstate.h"
//---------------------------------------------------------------------------
const std::string LogFile::m_log_filename = "log.txt";
//---------------------------------------------------------------------------
LogFile::LogFile()
{

}
//---------------------------------------------------------------------------
void LogFile::ClearLogFile()
{
  //Clear log file
  {
    std::ofstream f(m_log_filename.c_str());
    std::string t = GetTime();
    assert(!t.empty());
    //Pop back trailing newlines
    while (t[t.size() -1] == '\n')
    {
      assert(t.size() >= 1);
      t.resize(t.size() -1);
    }

    f << "<START>" << t << "</START>\n";
  }
}
//---------------------------------------------------------------------------
///Get the current time as a std::string
//From http://www.richelbilderbeek.nl/CppGetTime.htm
const std::string LogFile::GetTime()
{
  return TimeToStr(std::time(0));
}
//---------------------------------------------------------------------------
///Get the current time as a std::time_t
//From http://www.richelbilderbeek.nl/CppGetTime.htm
std::time_t LogFile::GetTimeT()
{
  return std::time(0);
}
//---------------------------------------------------------------------------
void LogFile::LogAction(const Participant * const participant)
{
  assert(participant->CanGetId());
  assert(!participant->GetActions().empty());
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f << "<choose_action>"
    << "<time>"
    << GetTime()
    << "</time>"
    << "<id>"
    << participant->GetId()
    << "</id>"
    << "<action>"
    << participant->GetActions().back()
    << "</action>"
    << "</choose_action>\n";
}
//---------------------------------------------------------------------------
///Log a Participant being assigned to a group
void LogFile::LogAssignGroup(
  const Group * const group,
  const Participant * const participant)
{
  assert(group);
  assert(participant);
  assert(participant->CanGetId());

  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f << "<assign_group>"
    << "<time>"
    << GetTime()
    << "</time>"
    << "<id>"
    << participant->GetId()
    << "</id>"
    << "<group>"
    << group->GetId()
    << "</group>"
    << "</assign_group>\n";
}
//---------------------------------------------------------------------------
void LogFile::LogExperimentStateChanged(const ServerState* new_state)
{
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f
    << "<experimentstate_change>"
    << "<time>"
    << GetTime()
    << "</time>"
    << new_state->ToStr()
    << "</experimentstate_change>\n";
}
//---------------------------------------------------------------------------
void LogFile::Login(const Participant * const participant)
{
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f
    << "<login>"
    << "<time>"
    << GetTime()
    << "</time>"
    << (*participant)
    << "</login>\n";
}
//---------------------------------------------------------------------------
void LogFile::Logout(const Participant * const participant)
{
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f
    << "<logout>"
    << "<time>"
    << GetTime()
    << "</time>"
    << (*participant)
    << "</logout>\n";
}
//---------------------------------------------------------------------------
void LogFile::LogVote(const Participant * const participant)
{
  assert(participant->CanGetId());
  assert(!participant->GetVotes().empty());
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f << "<choose_action>"
    << "<time>"
    << GetTime()
    << "</time>"
    << "<id>"
    << participant->GetId()
    << "</id>"
    << "<vote>"
    << participant->GetVotes().back()
    << "</vote>"
    << "</choose_action>\n";
}
//---------------------------------------------------------------------------
void LogFile::LogParameters(boost::shared_ptr<Parameters> parameters)
{
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f
    << "<set_parameters>"
    << "<time>"
    << GetTime()
    << "</time>"
    << (*parameters.get())
    << "</set_parameters>\n";
}
//---------------------------------------------------------------------------
void LogFile::LogParticipantDialogStateChanged(const ParticipantDialogState* const new_state)
{
  std::ofstream f(m_log_filename.c_str(),std::ios::app);

  f
    << "<participantdialogstate_change>"
    << "<time>"
    << GetTime()
    << "</time>"
    << new_state->ToStr()
    << "</participantdialogstate_change>\n";
}
//---------------------------------------------------------------------------
void LogFile::LogChatMessage(
  const Participant * const participant,
  const std::string& message)
{
  assert(participant);
  std::ofstream f(m_log_filename.c_str(),std::ios::app);
  f
    << "<chat>"
    << "<time>"
    << GetTime()
    << "</time>"
    << "<participant_id>"
    << participant->GetId()
    << "</participant_id>"
    << "<message>"
    << message
    << "</message>"
    << "</chat>\n";
}
//---------------------------------------------------------------------------
///TimeToStr converts std::time_t to std::string.
///From http://www.richelbilderbeek.nl/CppTimeToStr.htm
const std::string LogFile::TimeToStr(const std::time_t& time)
{
  return std::ctime( &time);
}
//---------------------------------------------------------------------------
