//---------------------------------------------------------------------------
///\mainpage GTST
///
///Welcome to the GTST documentation
///
///\author
///Richel Bilderbeek
///
///\remark
///In collaboration with Lucas Molleman, Piet van den Berg and
///Franjo Weissing
///
///\note
///- All pointers are either smart pointers, read-only raw pointers
///  or raw pointers managed by Wt
///\dot
///Communication {
/// node [shape=record, fontname=Helvetica, fontsize=10];
///  s [ label="server" URL="\ref Server"];
///  p [ label="class B" URL="\ref B"];
///  d [ label="class ParticipantDialog" URL="\ref ParticipantDialog"];
///  s -> p [ label="modifies" arrowhead="open", style="dashed"];
///}
///\enddot
///
///\todo
///- Implement policing after (majority) voting
///- let an Administrator also remain logged in by his/her IP
///- let a Partipant that has a browser refresh automatically go to the
///  Participant screens instead of to the Welcome screen
///- when a Participant participates, remove the menu items that are not
///  to be used anymore: Administrator, About, Experiment flow
///- Let all log files be saved as a different file with a timestamped filename
///- Show more experiment info
///- Add quiz at beginning
///- Add questionnaire at end
///- Show total payoff in the end
//---------------------------------------------------------------------------
#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WEnvironment>
#include <Wt/WFileUpload>
#include <Wt/WLabel>
#include <Wt/WLineEdit>
#include <Wt/WText>
#include <Wt/WTextArea>
#include <Wt/WTimer>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "ipaddress.h"
#include "logfile.h"
#include "stopwatch.h"
#include "wtautoconfig.h"
#include "menudialog.h"
#include "server.h"
#include "serverstate.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "trace.h"
//---------------------------------------------------------------------------
///\brief
///The Wt application of this program.
struct WtGameTheoryApplication : public Wt::WApplication
{
  ///Create a WtGameTheoryApplication
  WtGameTheoryApplication(const Wt::WEnvironment& env)
  : Wt::WApplication(env)
  {

    this->setTitle("GTST");
    this->useStyleSheet("wt.css");
    this->enableUpdates();
    const boost::scoped_ptr<SafeIpAddress> ip_address(
      new SafeIpAddress(env.clientAddress()));
    root()->addWidget(new gtst::MenuDialog(ip_address.get()));

  }
};
//---------------------------------------------------------------------------
///Create a Wt::WApplication
Wt::WApplication * createApplication(const Wt::WEnvironment& env)
{
  return new WtGameTheoryApplication(env);
}
//---------------------------------------------------------------------------
///The program's entry point
int main(int argc, char **argv)
{
  {
    START_TRACE();
  }
  {
    #ifndef NDEBUG
    Server::Get()->TestMe();
    #endif
  }

  WtAutoConfig a(argc,argv,createApplication);

  return a.Run();
}
//---------------------------------------------------------------------------
