//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
#include <stdexcept>
//---------------------------------------------------------------------------
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "parametersassignpayoff.h"
//---------------------------------------------------------------------------
ParametersAssignPayoff::ParametersAssignPayoff()
  : //m_group_benefit_contribute(1.5),
    //m_individual_cost_contribute(1.0),
    m_message("Assigning payoffs...")
{

}
//---------------------------------------------------------------------------
///Parse a line
void ParametersAssignPayoff::Parse(const std::string& s)
{
  if (s.size() > 27 && s.substr(0,27) == "individual_cost_contribute=")
  {
    const std::string t = s.substr(27,s.size()-27);
    /*
    try
    {
      boost::lexical_cast<double>(t);
    }
    catch (boost::bad_lexical_cast&)
    {
      throw std::runtime_error("assign_payoff_individual_cost_contribute must be a double");
    }
    const double assign_payoff_individual_cost_contribute = boost::lexical_cast<double>(t);
    if (assign_payoff_individual_cost_contribute <= 0.0) throw std::runtime_error("assign_payoff_individual_cost_contribute must posive");
    SetIndividualCostContribute(assign_payoff_individual_cost_contribute);
    */
    std::clog << "Obsolete parameter: assign_payoff_individual_cost_contribute\n";
    return;
  }
  if (s.size() > 25 && s.substr(0,25) == "group_benefit_contribute=")
  {
    /*
    const std::string t = s.substr(25,s.size()-25);
    try
    {
      boost::lexical_cast<double>(t);
    }
    catch (boost::bad_lexical_cast&)
    {
      throw std::runtime_error("assign_payoff_group_benefit_contribute must be a double");
    }
    const double assign_payoff_group_benefit_contribute = boost::lexical_cast<double>(t);
    if (assign_payoff_group_benefit_contribute <= 0.0) throw std::runtime_error("assign_payoff_group_benefit_contribute must posive");
    SetGroupBenefitContribute(assign_payoff_group_benefit_contribute);
    */
    std::clog << "Obsolete parameter: assign_payoff_group_benefit_contribute\n";
    return;
  }
  if (s.size() > 8 && s.substr(0,8) == "message=")
  {
    const std::string t = s.substr(8,s.size()-8);
    SetMessage(t);
    return;
  }

}
//---------------------------------------------------------------------------
///Set the benefit the individual gives to the group by contributing
/*
void ParametersAssignPayoff::SetGroupBenefitContribute(const double group_benefit_contribute)
{
  assert(group_benefit_contribute > 0.0);
  m_group_benefit_contribute = group_benefit_contribute;
}
*/
//---------------------------------------------------------------------------
///Get the cost the individual makes by contributing
/*
void ParametersAssignPayoff::SetIndividualCostContribute(const double individual_cost_contribute)
{
  assert(individual_cost_contribute > 0.0);
  m_individual_cost_contribute = individual_cost_contribute;
}
*/
//---------------------------------------------------------------------------
///Set the message displayed in the ParticipantDialogStateAssignPayoff
void ParametersAssignPayoff::SetMessage(const std::string& message)
{
  assert(!message.empty());
  m_message = message;
}
//---------------------------------------------------------------------------
std::ostream& operator<<(std::ostream& os,const ParametersAssignPayoff& parameters)
{
  os
    << "<parametersassignpayoff>"
    //<< "<group_benefit_contribute>"
    //<< parameters.GetGroupBenefitContribute()
    //<< "</group_benefit_contribute>"
    //<< "<individual_cost_contribute>"
    //<< parameters.GetIndividualCostContribute()
    //<< "</individual_cost_contribute>"
    << "<message>"
    << parameters.GetMessage()
    << "</message>"
    << "</parametersassignpayoff>";

  return os;
}
//---------------------------------------------------------------------------

