//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <algorithm>
#include <cassert>
#include <iostream>
#include <stdexcept>
#include <string>
//---------------------------------------------------------------------------
#include <boost/lexical_cast.hpp>
#include <boost/numeric/conversion/cast.hpp>
//---------------------------------------------------------------------------
#include "chooseactionoption.h"
#include "parameterschooseaction.h"
//---------------------------------------------------------------------------
ParametersChooseAction::ParametersChooseAction()
  : //m_contribute_action_index(-1),
    //m_do_not_contribute_action_index(-1),
    m_duration(5),
    m_wait(true)
{
  //SetActionDescriptions(CreateDefaultActionDescriptions());
}
//---------------------------------------------------------------------------
//const std::vector<std::string> ParametersChooseAction::CreateDefaultActionDescriptions()
//{
//  std::vector<std::string> v;
//  v.push_back("Contribute");
//  v.push_back("Do not contribute");
//  return v;
//}
//---------------------------------------------------------------------------
///GetContributeActionIndex returns the index that denotes 'contribute'
//int ParametersChooseAction::GetContributeActionIndex() const
//{
//
//  assert(m_contribute_action_index != -1
//    && "m_contribute_action_index must be initialized");
//  return m_contribute_action_index;
//}
//---------------------------------------------------------------------------
///GetDoNotContributeActionIndex returns the index that denotes 'do not contribute'
//int ParametersChooseAction::GetDoNotContributeActionIndex() const
//{
//  assert(m_do_not_contribute_action_index != -1
//    && "m_do_not_contribute_action_index must be initialized");
//  return m_do_not_contribute_action_index;
//}
//---------------------------------------------------------------------------
int ParametersChooseAction::GetDuration() const
{
  assert(m_duration >= 0);
  return m_duration;
}
//---------------------------------------------------------------------------
///Get the number of actions to choose from
//int ParametersChooseAction::GetNumberOfOptions() const
//{
//  const int n_options
//    = boost::numeric_cast<int>(m_action_descriptions.size());
//  assert(n_options > 1
//    && "There must be at least two actions to choose from");
//
//  return n_options;
//}
//---------------------------------------------------------------------------
///Parse a line
void ParametersChooseAction::Parse(const std::string& s)
{
  if (s.size() > 5 && s.substr(0,5) == "wait=")
  {
    const std::string t = s.substr(5,s.size()-5);
    if (t=="y" || t=="Y" || t=="1" || t == "n" || t == "N" || t =="0")
    {
      if (t=="y" || t=="Y" || t=="1")
      {
        SetWait(true);
      }
      else
      {
        SetWait(false);
      }
    }
    else
    {
      throw std::runtime_error("choose_action_wait me be either \'y\' or \'n\'");
    }
    return;
  }
  if (s.size() > 9 && s.substr(0,9) == "duration=")
  {
    const std::string t = s.substr(9,s.size()-9);
    try
    {
      boost::lexical_cast<int>(t);
    }
    catch (boost::bad_lexical_cast&)
    {
      throw std::runtime_error("choose_action_duration must be an integer");
    }
    const int time = boost::lexical_cast<int>(t);
    if (time < 0) throw std::runtime_error("choose_action_duration must be zero or posive");
    SetDuration(time);
    return;
  }

  if (s.size() > 7 && s.substr(0,7) == "option=")
  {
    const std::string t = s.substr(7,s.size() - 7);
    const std::vector<std::string> v = SeperateString(t,',');
    if (v.size() != 3)
    {
      std::clog
        << "Incorrectly formed choose_action_option line: " << s << '\n'
        << "Must consist of [description][contribution][cost]\n"
        << "For example \'Contribute,2.0,1.0\'\n";
      return;
    }
    assert(v.size() == 3 && "vote_options must have two elements");

    const std::string description = v[0];
    const std::string contribution_str = v[1];
    const std::string cost_str = v[2];

    try
    {
      boost::lexical_cast<double>(contribution_str);
    }
    catch (std::logic_error&)
    {
      std::clog
        << "Incorrectly formed contribution: "
        << contribution_str
        << '\n';
      return;
    }
    try
    {
      boost::lexical_cast<double>(cost_str);
    }
    catch (std::logic_error&)
    {
      std::clog
        << "Incorrectly formed cost: "
        << cost_str
        << '\n';
      return;
    }

    const double contribution = boost::lexical_cast<double>(contribution_str);
    const double cost = boost::lexical_cast<double>(cost_str);

    boost::shared_ptr<ChooseActionOption> p(
      new ChooseActionOption(contribution,cost,description));
    m_options.push_back(p);
    //std::clog << "Added an option!\n";
    return;
  }
}
//---------------------------------------------------------------------------
///SeperateString splits a std::string
//From http://www.richelbilderbeek.nl/CppSeperateString.htm
const std::vector<std::string> ParametersChooseAction::SeperateString(
  const std::string& input,
  const char seperator)
{
  std::istringstream is(input);
  std::vector<std::string> v;
  for (
    std::string sub;
    std::getline(is, sub, seperator);
    v.push_back(sub))
  {
    //Empty for loop
  }
  return v;
}
//---------------------------------------------------------------------------
///Set the descriptions of the actions to be chosen by the Participant
/*
void ParametersChooseAction::SetActionDescriptions(const std::vector<std::string>& action_descriptions)
{
  assert(action_descriptions.size() >= 2
    && "A participant must choose from at least two actions");
  m_action_descriptions = action_descriptions;

  //Reset all action indices
  m_contribute_action_index = -1;
  m_do_not_contribute_action_index = -1;

  //Set the action indices
  const int n_descriptors
    = boost::numeric_cast<int>(m_action_descriptions.size());
  for (int i=0; i!=n_descriptors; ++i)
  {
    if ( StrToLower(m_action_descriptions[i]) == "contribute"
      || StrToLower(m_action_descriptions[i]) == "ik zet mijn beste beentje voor")
    {
      m_contribute_action_index = i;
    }
    if ( StrToLower(m_action_descriptions[i])== "do not contribute"
      || StrToLower(m_action_descriptions[i])== "de ander kan de tering krijgen")
    {
      m_do_not_contribute_action_index = i;
    }
  }

  //Assume all action indices are valid
  assert(m_contribute_action_index != -1
    && "The action descriptions of ParametersChooseAction do not have an implemented \'contribute\' label");
  assert(m_do_not_contribute_action_index != -1
    && "The action descriptions of ParametersChooseAction do not have an implemented \'do not contribute\' label");

}
*/
//---------------------------------------------------------------------------
void ParametersChooseAction::SetDuration(const int time)
{
  m_duration = time;
  assert(m_duration >= 0);
}
//---------------------------------------------------------------------------
///Converts a std::string to lower case
//From http://www.richelbilderbeek.nl/CppStrToLower.htm
const std::string ParametersChooseAction::StrToLower(std::string s)
{
  std::transform(s.begin(), s.end(), s.begin(),
    std::ptr_fun<int,int>(std::tolower));
  return s;
}
//---------------------------------------------------------------------------
std::ostream& operator<<(std::ostream& os,const ParametersChooseAction& parameters)
{
  os
    << "<parameterschooseaction>"
    << "<duration>"
    << parameters.GetDuration()
    << "</duration>"
    << "<wait>"
    << parameters.GetWait()
    << "</wait>";
  const int n_actions = boost::numeric_cast<int>(
    parameters.GetOptions().size());
  for (int i=0; i!=n_actions;++i)
  {
    os
      << "<option" << i << ">"
      << (*(parameters.GetOptions()[i]))
      << "</option" << i << ">";
  }
  os
    << "</parameterschooseaction>";
  return os;
}
//---------------------------------------------------------------------------

