//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
//---------------------------------------------------------------------------
#include "parametersfinished.h"
//---------------------------------------------------------------------------
ParametersFinished::ParametersFinished()
  : m_message("Thanks for participating in this experiment")
{

}
//---------------------------------------------------------------------------
///Parse a line
void ParametersFinished::Parse(const std::string& s)
{
  if (s.size() > 8 && s.substr(0,8) == "message=")
  {
    const std::string t = s.substr(8,s.size()-8);
    SetMessage(t);
    return;
  }
}
//---------------------------------------------------------------------------
///Set the message shown to the Participant when the experiment has finished
void ParametersFinished::SetMessage(const std::string& message)
{
  assert(!message.empty());
  m_message = message;
}
//---------------------------------------------------------------------------
std::ostream& operator<<(std::ostream& os,const ParametersFinished& parameters)
{
  os
    << "<parameterschat>"
    << "<message>"
    << parameters.GetMessage()
    << "</message>"
    << "</parameterschat>";

  return os;
}
//---------------------------------------------------------------------------

