//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <algorithm>
#include <cassert>
#include <cctype>
#include <iostream>
#include <stdexcept>
#include <string>
//---------------------------------------------------------------------------
#include "parametersgroupdynamics.h"
//---------------------------------------------------------------------------
ParametersGroupDynamics::ParametersGroupDynamics()
  : m_type(ParametersGroupDynamics::static_dynamics),
    m_message_assigned("Waiting for others. You have been assigned to group "),
    m_message_unassigned("Waiting for server to assign you to a group")
{

}
//---------------------------------------------------------------------------
///Parse a line
void ParametersGroupDynamics::Parse(const std::string& s)
{
  if (s.size() > 19 && s.substr(0,19) == "message_unassigned=")
  {
    const std::string t = s.substr(19,s.size()-19);
    SetMessageUnassigned(t);
    return;
  }
  if (s.size() > 17 && s.substr(0,17) == "message_assigned=")
  {
    const std::string t = s.substr(17,s.size()-17);
    SetMessageAssigned(t);
    return;
  }

  if (s.size() > 5 && s.substr(0,5) == "type=")
  {
    const std::string t = StrToLower(s.substr(5,s.size()-5));
    const std::string s1 = "static";
    const std::string s2 = "dynamic";
    if (std::search(t.begin(),t.end(),s1.begin(),s1.end()) != t.end())
    {
      SetType(ParametersGroupDynamics::static_dynamics);
    }
    else if (std::search(t.begin(),t.end(),s2.begin(),s2.end()) != t.end())
    {
      SetType(ParametersGroupDynamics::dynamic);
    }
    else
    {
      throw std::runtime_error(
          std::string("ParametersGroupDynamics type must be either ")
        + std::string("\'static\' or \'dynamic\', instead of \'")
        + t
        + std::string("\'"));
    }
    return;
  }
}
//---------------------------------------------------------------------------
///Set the message shown to an assigned participant
void ParametersGroupDynamics::SetMessageAssigned(const std::string& message)
{
  assert(!message.empty());
  m_message_assigned = message;
}
//---------------------------------------------------------------------------
///Set the message shown to an unassigned participant
void ParametersGroupDynamics::SetMessageUnassigned(const std::string& message)
{
  assert(!message.empty());
  m_message_unassigned = message;
}
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/CppStrToLower.htm
const std::string ParametersGroupDynamics::StrToLower(std::string s)
{
  std::transform(s.begin(), s.end(), s.begin(),std::ptr_fun<int,int>(std::tolower));
  return s;
}
//---------------------------------------------------------------------------
std::ostream& operator<<(std::ostream& os,const ParametersGroupDynamics& parameters)
{
  os
    << "<parameterschat>"
    << "<messageassigned>"
    << parameters.GetMessageAssigned()
    << "</messageassigned>"
    << "<messageunassigned>"
    << parameters.GetMessageUnassigned()
    << "</messageunassigned>"
    << "</parameterschat>";

  return os;
}
//---------------------------------------------------------------------------

