//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
#include <stdexcept>
//---------------------------------------------------------------------------
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "parametersviewresultsvoting.h"
//---------------------------------------------------------------------------
ParametersViewResultsVoting::ParametersViewResultsVoting()
  : m_duration(5)
{
}
//---------------------------------------------------------------------------
int ParametersViewResultsVoting::GetDuration() const
{
  assert(m_duration >= 0);
  return m_duration;
}
//---------------------------------------------------------------------------
///Parse a line
void ParametersViewResultsVoting::Parse(const std::string& s)
{
  //View results time in the same group, in the IPGG phase
  if (s.size() > 9 && s.substr(0,9) == "duration=")
  {
    const std::string t = s.substr(9,s.size()-9);
    try
    {
      boost::lexical_cast<int>(t);
    }
    catch (boost::bad_lexical_cast&)
    {
      throw std::runtime_error("view_results_voting_duration must be an integer");
    }
    const int time = boost::lexical_cast<int>(t);
    if (time < 0) throw std::runtime_error("view_results_voting_duration must be zero or posive");
    SetDuration(time);
    return;
  }
}
//---------------------------------------------------------------------------
void ParametersViewResultsVoting::SetDuration(const int time)
{
  m_duration = time;
  assert(m_duration >= 0);
}
//---------------------------------------------------------------------------
std::ostream& operator<<(std::ostream& os,const ParametersViewResultsVoting& parameters)
{
  os
    << "<parametersviewresultsvoting>"
    << "<time>"
    << parameters.GetDuration()
    << "</time>"
    << "</parametersviewresultsvoting>";

  return os;
}
//---------------------------------------------------------------------------

