//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
//---------------------------------------------------------------------------
#include <Wt/WApplication>
#include <Wt/WTimer>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "ipaddress.h"
#include "logfile.h"
#include "participant.h"
#include "participantdialog.h"
#include "participantdialogstate.h"
#include "participantdialogstateassignpayoff.h"
#include "participantdialogstatechat.h"
#include "participantdialogstatechooseaction.h"
#include "participantdialogstatefinished.h"
#include "participantdialogstategroupdynamics.h"
#include "participantdialogstateloggedin.h"
#include "participantdialogstatenotloggedin.h"
#include "participantdialogstateviewresultsall.h"
#include "participantdialogstateviewresultsgroup.h"
#include "participantdialogstateviewresultsvoting.h"
#include "participantdialogstatevoting.h"
#include "server.h"
#include "state.h"
#include "stopwatch.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
///\note
///Do not make m_timer a child of this,
///to prevent it being delete by Wt classes
ParticipantDialog::ParticipantDialog(const SafeIpAddress * const ip_address)
  : m_ip_address(new SafeIpAddress(ip_address->Get())),
    m_participant(0),
    m_state(0),
    m_state_assign_payoff(new ParticipantDialogStateAssignPayoff(this)),
    m_state_chat(new ParticipantDialogStateChat(this)),
    m_state_choose_action(new ParticipantDialogStateChooseAction(this)),
    m_state_finished(new ParticipantDialogStateFinished(this)),
    m_state_group_dynamics(new ParticipantDialogStateGroupDynamics(this)),
    m_state_logged_in(new ParticipantDialogStateLoggedIn(this)),
    m_state_not_logged_in(new ParticipantDialogStateNotLoggedIn(this)),
    m_state_view_results_all(new ParticipantDialogStateViewResultsAll(this)),
    m_state_view_results_group(new ParticipantDialogStateViewResultsGroup(this)),
    m_state_view_results_voting(new ParticipantDialogStateViewResultsVoting(this)),
    m_state_voting(new ParticipantDialogStateVoting(this)),
    m_timer(new Wt::WTimer)
{
  assert(!m_participant && "Participant is obtained from Server");
  assert(!m_state && "m_state is initialized below");
  assert(m_state_assign_payoff);
  assert(m_state_chat);
  assert(m_state_choose_action);
  assert(m_state_finished);
  assert(m_state_group_dynamics);
  assert(m_state_logged_in);
  assert(m_state_not_logged_in);
  assert(m_state_view_results_all);
  assert(m_state_view_results_group);
  assert(m_state_view_results_voting);
  assert(m_state_voting);
  assert(m_timer);

  assert(Wt::WApplication::instance()->updatesEnabled());

  this->SetState(this->GetStateNotLoggedIn());
  assert(m_state);
  m_state->ShowPage();

  m_timer->timeout().connect(this,&ParticipantDialog::OnTimer);
  assert(Server::m_poll_time > 0);
  m_timer->setInterval(Server::m_poll_time);
  m_timer->start();
}
//---------------------------------------------------------------------------
ParticipantDialog::~ParticipantDialog()
{
  assert(m_timer);
  //m_timer->stop();
  //assert(!"I SHOULD NEVER BE CALLED EXCEPT IN THE END...");

  //if (m_state) m_state->Logout();
}
//---------------------------------------------------------------------------
bool ParticipantDialog::CanGetParticipant() const
{
  return m_participant;
}
//---------------------------------------------------------------------------
///Do something random with the UI, used by DebugDialog
void ParticipantDialog::DoSomethingRandom()
{
  m_state->DoSomethingRandom();
}
//---------------------------------------------------------------------------
ParticipantDialogState * ParticipantDialog::GetCurrentState() const
{
  assert(m_state);
  return m_state;
}
//---------------------------------------------------------------------------
///Get this ParticipantDialog its IP address
const SafeIpAddress * ParticipantDialog::GetIpAddress() const
{
  assert(m_ip_address);
  return m_ip_address.get();
}
//---------------------------------------------------------------------------
const Participant * ParticipantDialog::GetParticipant() const
{
  assert(CanGetParticipant());
  return m_participant;
}
//---------------------------------------------------------------------------
ParticipantDialogStateChat * ParticipantDialog::GetStateChat() const
{
  assert(m_state_chat);
  return m_state_chat.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateAssignPayoff * ParticipantDialog::GetStateAssignPayoff() const
{
  assert(m_state_assign_payoff);
  return m_state_assign_payoff.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateChooseAction * ParticipantDialog::GetStateChooseAction() const
{
  assert(m_state_choose_action);
  return m_state_choose_action.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateFinished * ParticipantDialog::GetStateFinished() const
{
  assert(m_state_finished);
  return m_state_finished.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateGroupDynamics * ParticipantDialog::GetStateGroupDynamics() const
{
  assert(m_state_group_dynamics);
  return m_state_group_dynamics.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateLoggedIn * ParticipantDialog::GetStateLoggedIn() const
{
  assert(m_state_logged_in);
  return m_state_logged_in.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateViewResultsAll * ParticipantDialog::GetStateViewResultsAll() const
{
  assert(m_state_view_results_all);
  return m_state_view_results_all.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateViewResultsGroup * ParticipantDialog::GetStateViewResultsGroup() const
{
  assert(m_state_view_results_group);
  return m_state_view_results_group.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateViewResultsVoting * ParticipantDialog::GetStateViewResultsVoting() const
{
  assert(m_state_view_results_voting);
  return m_state_view_results_voting.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateVoting * ParticipantDialog::GetStateVoting() const
{
  assert(m_state_voting);
  return m_state_voting.get();
}
//---------------------------------------------------------------------------
ParticipantDialogStateNotLoggedIn * ParticipantDialog::GetStateNotLoggedIn() const
{
  assert(m_state_not_logged_in);
  return m_state_not_logged_in.get();
}
//---------------------------------------------------------------------------
void ParticipantDialog::SetParticipant(const Participant * const participant)
{
  assert(participant);
  m_participant = participant;
}
//---------------------------------------------------------------------------
///Let a State perform a transition that is logged and lets the new State be drawn to screen.
void ParticipantDialog::SetState(ParticipantDialogState * const state)
{
  if (state == m_state) return;
  assert(state);
  m_state = state;
  assert(m_state);

  //Log the change in state
  Server::Get()->GetLog()->LogParticipantDialogStateChanged(GetCurrentState());

  //m_state->SetParticipantState();

  //Show the new page
  m_state->ShowPage();
}
//---------------------------------------------------------------------------
//void ParticipantDialog::OnServerTimer()
//{
//  //std::clog << "ParticipantDialog::OnServerTimer()\n";
//  assert(m_state);
//  m_state->OnTimer();
//}
//---------------------------------------------------------------------------
void ParticipantDialog::OnTimer()
{
  //std::clog << "ParticipantDialog::OnTimer()\n";
  //OnServerTimer();
  assert(m_state);
  m_state->OnTimer();
}
//---------------------------------------------------------------------------
