//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <fstream>
#include <iostream>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "logfile.h"
#include "participant.h"
#include "participantdialog.h"
#include "participantdialogstate.h"
#include "participantdialogstateassignpayoff.h"
#include "participantdialogstatechat.h"
#include "participantdialogstatechooseaction.h"
#include "participantdialogstatefinished.h"
#include "participantdialogstategroupdynamics.h"
#include "participantdialogstateloggedin.h"
#include "participantdialogstatenotloggedin.h"
#include "participantdialogstateviewresultsall.h"
#include "participantdialogstateviewresultsgroup.h"
#include "participantdialogstateviewresultsvoting.h"
#include "participantdialogstatevoting.h"
#include "participantstate.h"
#include "participantstateassignpayoff.h"
#include "participantstatechat.h"
#include "participantstatechooseaction.h"
#include "participantstatefinished.h"
#include "participantstategroupdynamics.h"
#include "participantstateloggedin.h"
#include "participantstatenotloggedin.h"
#include "participantstateviewresultsall.h"
#include "participantstateviewresultsgroup.h"
#include "participantstateviewresultsvoting.h"
#include "participantstatevoting.h"
#include "state.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstate.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "trace.h"
//---------------------------------------------------------------------------
#undef NDEBUG
#include <cassert>
//---------------------------------------------------------------------------
ParticipantDialogState::ParticipantDialogState(
  ParticipantDialog * const dialog)
  : m_dialog(dialog)
{
  assert(m_dialog);
}
//---------------------------------------------------------------------------
///FileExists checks if a certain file exists
///From http://www.richelbilderbeek.nl/CppFileExists.htm
bool ParticipantDialogState::FileExists(const std::string& filename)
{
  std::fstream f;
  f.open(filename.c_str(),std::ios::in);
  return f.is_open();
}
//---------------------------------------------------------------------------
///FileToVector reads a file and converts it to a std::vector<std::string>
///From http://www.richelbilderbeek.nl/CppFileToVector.htm
const std::vector<std::string> ParticipantDialogState::FileToVector(const std::string& filename)
{
  assert(FileExists(filename));
  std::vector<std::string> v;
  std::ifstream in(filename.c_str());
  std::string s;
  for (int i=0; !in.eof(); ++i)
  {
    std::getline(in,s);
    v.push_back(s);
  }
  return v;
}
//---------------------------------------------------------------------------
//bool ParticipantDialogState::IsLoggedIn() const
//{
//  return GetDialog()->CanGetParticipant();
//}
//---------------------------------------------------------------------------
void ParticipantDialogState::Logout()
{
  //if (IsLoggedIn())
  //{
  //  assert(GetDialog()->CanGetParticipant());
    Server::Get()->NotifyLogout(GetDialog()->GetParticipant());
  //}
}
//---------------------------------------------------------------------------
/*
void ParticipantDialogState::RespondToServer()
{
  assert(GetDialog()->CanGetParticipant()
    && "Only logged in participants follow the server");


  Server::Get()->WakeUp();

  //As long is there is no group assigned,
  //wait at the group dynamics screen
  if (!GetDialog()->GetParticipant()->IsParticipating())
  {
    m_dialog->SetState(m_dialog->GetStateGroupDynamics());
    return;
  }

  if (GetDialog()->GetParticipant()->IsFinished())
  {
    m_dialog->SetState(m_dialog->GetStateFinished());
    return;
  }


  const std::string s = Server::Get()->GetCurrentState()->ToStr();

  if (s == State::AssignPayoffString)
  {
    m_dialog->SetState(m_dialog->GetStateAssignPayoff());
  }
  else if (s == State::ChatString)
  {
    assert(GetDialog()->GetParticipant()->IsParticipating()
      && "Only partipating Participants can chat");
    m_dialog->SetState(m_dialog->GetStateChat());
  }
  else if (s == State::ChooseActionString)
  {
    assert(GetDialog()->GetParticipant()->IsParticipating()
      && "Only partipating Participants can choose an action");
    m_dialog->SetState(m_dialog->GetStateChooseAction());
  }
  else if (s == State::FinishedString)
  {
    m_dialog->SetState(m_dialog->GetStateFinished());
  }
  else if (s == State::GroupDynamicsString)
  {
    m_dialog->SetState(m_dialog->GetStateGroupDynamics());
  }
  else if (s == State::NotLoggedInString)
  {
    m_dialog->SetState(m_dialog->GetStateNotLoggedIn());
  }
  else if (s == State::ViewResultsAllString)
  {
    assert(GetDialog()->GetParticipant()->IsParticipating()
      && "Only partipating Participants can view all results");
    m_dialog->SetState(m_dialog->GetStateViewResultsAll());
  }
  else if (s == State::ViewResultsGroupString)
  {
    assert(GetDialog()->GetParticipant()->IsParticipating()
      && "Only partipating Participants can view his/her group results");
    m_dialog->SetState(m_dialog->GetStateViewResultsGroup());
  }
  else if (s == State::ViewResultsVotingString)
  {
    assert(GetDialog()->GetParticipant()->IsParticipating()
      && "Only partipating Participants can view the voting results");

    m_dialog->SetState(m_dialog->GetStateViewResultsVoting());
  }
  else if (s == State::VotingString)
  {
    assert(GetDialog()->GetParticipant()->IsParticipating()
      && "Only partipating Participants can vote");
    m_dialog->SetState(m_dialog->GetStateVoting());
  }
  else if (s == State::WaitingString)
  {
    assert(!"Should not happen: a Participant is not waiting, but not logged in");
    throw std::logic_error("ParticipantDialogState::RespondToServer: a Participant never waits");
  }
  else
  {
    const std::string error
      = std::string("Unimplemented state: ")
      + s;
    std::cerr << error << '\n';
    std::clog << error << '\n';
    assert("Should not get here, there must be an unimplemented state");
    throw std::logic_error(
      "Should not get here (ParticipantDialogState::RespondToActionFile), there must be an unimplemented state");
  }
}
*/
//---------------------------------------------------------------------------
///Respons to the Participant his/her ParticipantState, which
///can be changed by the Server
void ParticipantDialogState::RespondToParticipant()
{
  TRACE_FUNC();

  assert(GetDialog()->CanGetParticipant()
    && "Only logged in participants follow the server");


  Server::Get()->WakeUp();


  //As long is there is no group assigned,
  //wait at the group dynamics screen
  //if (!GetDialog()->GetParticipant()->IsParticipating())
  //{
  //  m_dialog->SetState(m_dialog->GetStateGroupDynamics());
  //  return;
  //}

  //if (GetDialog()->GetParticipant()->IsFinished())
  //{
  //  m_dialog->SetState(m_dialog->GetStateFinished());
  //  return;
  //}
  assert(GetDialog());
  assert(GetDialog()->GetParticipant());
  assert(GetDialog()->GetParticipant()->GetState());

  const ParticipantState * const state = this->GetDialog()->GetParticipant()->GetState();

  if (dynamic_cast<const ParticipantStateAssignPayoff*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateAssignPayoff());
  }
  else if (dynamic_cast<const ParticipantStateChat*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateChat());
  }
  else if (dynamic_cast<const ParticipantStateChooseAction*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateChooseAction());
  }
  else if (dynamic_cast<const ParticipantStateFinished*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateFinished());
  }
  else if (dynamic_cast<const ParticipantStateGroupDynamics*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateGroupDynamics());
  }
  else if (dynamic_cast<const ParticipantStateLoggedIn*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateLoggedIn());
  }
  else if (dynamic_cast<const ParticipantStateNotLoggedIn*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateNotLoggedIn());
  }
  else if (dynamic_cast<const ParticipantStateViewResultsAll*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateViewResultsAll());
  }
  else if (dynamic_cast<const ParticipantStateViewResultsGroup*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateViewResultsGroup());
  }
  else if (dynamic_cast<const ParticipantStateViewResultsVoting*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateViewResultsVoting());
  }
  else if (dynamic_cast<const ParticipantStateVoting*>(state))
  {
    m_dialog->SetState(m_dialog->GetStateVoting());
  }
  //else if (dynamic_cast<const ParticipantStateWaiting*>(state))
  //{
  //  assert(!"Should not happen: a Participant is not waiting, but not logged in");
  //  throw std::logic_error("ParticipantDialogState::RespondToServer: a Participant never waits");
  //}
  else
  {
    const std::string error
      = std::string("Unimplemented state: ")
      + state->ToStr();
    std::cerr << error << '\n';
    std::clog << error << '\n';
    assert("Should not get here, there must be an unimplemented state");
    throw std::logic_error(
      "Should not get here (ParticipantDialogState::RespondToActionFile), there must be an unimplemented state");
  }
  #define DEBUG_76321276986216512542763275764328398
  #ifdef  DEBUG_76321276986216512542763275764328398
  if (this->GetDialog()->GetCurrentState()->ToStr()
    != GetDialog()->GetParticipant()->GetState()->ToStr())
  {
    std::cerr
      << "GetDialog()->GetCurrentState()->ToStr(): "
      << GetDialog()->GetCurrentState()->ToStr() << '\n'
      << "GetDialog()->GetParticipant()->GetState()->ToStr(): "
      << GetDialog()->GetParticipant()->GetState()->ToStr() << '\n';
  }
  #endif
  assert(this->GetDialog()->GetCurrentState()->ToStr()
    == GetDialog()->GetParticipant()->GetState()->ToStr());

}
//---------------------------------------------------------------------------
///Change the Participant's State to the ParticipantDialogState
///void ParticipantDialogStateSetParticipantState();
