//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#ifndef PARTICIPANTDIALOGSTATE_H
#define PARTICIPANTDIALOGSTATE_H
//---------------------------------------------------------------------------
#include <string>
#include <vector>
//---------------------------------------------------------------------------
#include <boost/checked_delete.hpp>
//---------------------------------------------------------------------------
#include <Wt/WObject>
//---------------------------------------------------------------------------
#include "forward_declarations.h"
#include "state.h"
//---------------------------------------------------------------------------
///\brief
///The state of ParticipantDialog.
///
///The State Design Pattern of the ParticipantDialog.
///ParticipantDialog is an Observer of Participant
struct ParticipantDialogState : public State, Wt::WObject
{
  ///Create every ParticipantDialogState with a pointer to
  ///its ParticipantDialog
  ParticipantDialogState(ParticipantDialog * const dialog);

  ///Do something random with the UI, used by DebugDialog
  virtual void DoSomethingRandom() = 0;

  ///OnTimer performs the state transitions
  virtual void OnTimer() = 0;

  ///ShowPage shows the webpage
  virtual void ShowPage() = 0;
  //virtual const std::string ToStr() const = 0;

  ///Get the ParticipantDialog
  ParticipantDialog * GetDialog() const { return m_dialog; }


  ///Responds to the Participant his/her ParticipantState, which
  ///can be changed by the Server
  void RespondToParticipant();

  //void RespondToState();


  ///Change the Participant's State to the ParticipantDialogState
  //void SetParticipantState();
  //virtual void SetParticipantState() = 0;

  protected:
  ///Only let a smart pointer delete this ParticipantDialogState
  virtual ~ParticipantDialogState() {}
  ///Only let a smart pointer delete this ParticipantDialogState
  //Do not forget the template brackets, as stated in
  //Herb Sutter. Exceptional C++ style. 2005. ISBN: 0-201-76042-8. Item 8: 'Befriending templates'.
  friend void boost::checked_delete<>(ParticipantDialogState*);

  //bool IsLoggedIn() const;

  private:
  ///The dialog this state works on
  ParticipantDialog * const m_dialog;

  //Nobody logs out: he/she refreshes or has a browser crash
  void Logout();

  public:
  bool FileExists(const std::string& filename);
  const std::vector<std::string> FileToVector(const std::string& filename);
};
//---------------------------------------------------------------------------
#endif // PARTICIPANTDIALOGSTATE_H
