//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <fstream>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WLabel>
#include <Wt/WLineEdit>
#include <Wt/WTextArea>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "group.h"
#include "groups.h"
#include "logfile.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstate.h"
#include "serverstatechat.h"
#include "participantdialog.h"
#include "participantdialogstate.h"
#include "participantdialogstatechat.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "trace.h"
//---------------------------------------------------------------------------
ParticipantDialogStateChat::ParticipantDialogStateChat(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog),
    m_edit_chat(0),
    m_label_group(0),
    m_label_id(0),
    m_label_status(0),
    m_label_time_left(0),
    m_text_chat(0)
{

}
//---------------------------------------------------------------------------
///Do something random with the UI, used by DebugDialog
void ParticipantDialogStateChat::DoSomethingRandom()
{
  switch (std::rand() % 10)
  {
    case 0: m_edit_chat->setText(GetRandomDebugString()); break;
    case 1: SubmitChatText(); break;
    default: break; //No problem
  }
}
//---------------------------------------------------------------------------
const std::string ParticipantDialogStateChat::GetRandomDebugString() const
{
  static std::vector<std::string> v;
  if (v.empty())
  {
    v.push_back("A single spark can set a prairie on fire");
    v.push_back("Water can both sustain and sink a ship");
    v.push_back("Count not what is lost, but what is left");
    v.push_back("If there is a strong general there will be no weak soldiers");
    v.push_back("To extend your life by a year take one less bite each meal");
    v.push_back("Peace only comes when reason rules");
    v.push_back("Even the tallest tower started from the ground");
    v.push_back("Eloquence provides only persuasion, but truth buys loyalty");
    v.push_back("Wisdom is attained by learning when to hold one's tongue");
    v.push_back("A single tree cannot make a forest");
    v.push_back("If one eats less one will taste more");
    v.push_back("One hand alone cannot clap, it takes two to quarrel");
    v.push_back("It does not matter if the cat is black or white, so long as it catches mice");
    v.push_back("Cowards have dreams, brave men have visions");
    v.push_back("Learning is like the horizon; there is no limit");
    v.push_back("The old horse will know the way");
    v.push_back("A good friend shields you from the storm");
    v.push_back("Change the skin, wash the heart");
    v.push_back("Sow melon, reap melon; sow beans, reap beans");
    v.push_back("One sings, all follow");
    v.push_back("Fortune has a fickle heart and a short memory");
    v.push_back("Harsh words and poor reasoning never settle anything");
    v.push_back("Dangerous enemies will meet again in narrow streets");
    v.push_back("Better to bend in the wind than to break");
    v.push_back("Do not kill the hen for her eggs");
    v.push_back("First attain skill; creativity comes later");
    v.push_back("Make the cap fit the head");
    v.push_back("A single beam cannot support a great house");
    v.push_back("Do not be concerned with things outside your door");
    v.push_back("Wise men may not be learned; learned men may not be wise");
    v.push_back("Crows are black the world over");
    v.push_back("Do not lift a rock only to drop it on your own foot");
    v.push_back("Kill the chicken to frighten the monkey");
    v.push_back("Wait long, strike fast");
    v.push_back("Do not wait until you're thirsty to dig a well");
    v.push_back("One who would pick the roses must bear with thorns");
    v.push_back("Failure is the mother of success");
    v.push_back("Do not climb a tree to look for a fish");
    v.push_back("Only time and effort brings proficiency");
    v.push_back("Distance tests the endurance of a horse; time reveals a man's character");
  }
  assert(!v.empty());
  std::string s = v[ std::rand() % v.size() ];
  return s;
}
//---------------------------------------------------------------------------
void ParticipantDialogStateChat::OnTimer()
{
  TRACE_FUNC();
  assert(Server::Get());

  TRACE("(1) ParticipantDialogStateChat::OnTimer");
  const int time_left = Server::Get()->GetTimeLeft();

  //Update label_time_left
  {
    TRACE("(2) ParticipantDialogStateChat::OnTimer");
    const std::string text
    =  std::string("Time left: ")
    + boost::lexical_cast<std::string>(time_left)
    + std::string(" seconds ");
    assert(m_label_time_left);
    m_label_time_left->setText(text.c_str());
  }

  TRACE("(3) ParticipantDialogStateChat::OnTimer");
  assert(GetDialog()->CanGetParticipant());
  assert(GetDialog()->GetParticipant()->GetId() >= 0);

  //Get chat messages for this participant
  if (Server::Get()->GetStateChat()->CanGetChatMessages(
    GetDialog()->GetParticipant()))
  {
    TRACE("(4) ParticipantDialogStateChat::OnTimer");
    const std::vector<std::string> chat_messages
      = Server::Get()->GetStateChat()->GetChatMessages(
          GetDialog()->GetParticipant());
    std::string text = m_text_chat->text().toUTF8();
    BOOST_FOREACH(const std::string& chat_message,
      chat_messages)
    {
      TRACE(text);
      text = chat_message+'\n'+text; //Reverse ordering: newest on top
      TRACE(text);
    }
    //Pop back trailing newline
    //assert(text.size() >= 1);
    //text.resize(text.size()-1);
    TRACE("(5) ParticipantDialogStateChat::OnTimer");
    m_text_chat->setText(text.c_str());
  }

  TRACE("(6) ParticipantDialogStateChat::OnTimer");
  //Display the Participant
  RespondToParticipant();

  TRACE("(7) ParticipantDialogStateChat::OnTimer");
}
//---------------------------------------------------------------------------
void ParticipantDialogStateChat::ShowPage()
{
  ParticipantDialog * const dialog = GetDialog();
  assert(dialog);

  dialog->clear(); //Wt deletes all dialog's child widgets

  assert(GetDialog()->CanGetParticipant()
    && "Assume a logged in participant");

  m_edit_chat = new Wt::WLineEdit(
    std::string("Hello from ")
    + boost::lexical_cast<std::string>(GetDialog()->GetParticipant()->GetId()));
  m_label_status = new Wt::WLabel("Welcome participant");

  assert(GetDialog()->GetParticipant()->CanGetId()
    && "Assume a logged in participant with an ID");

  m_label_id = new Wt::WLabel(
      std::string("You have ID ")
    + boost::lexical_cast<std::string>(GetDialog()->GetParticipant()->GetId())
    + std::string(" and your chat tag is ")
    + boost::lexical_cast<std::string>(GetDialog()->GetParticipant()->GetChatTag()
    ));



  m_label_group = new Wt::WLabel(
    std::string("You are in group number ")
    + boost::lexical_cast<std::string>(
      Server::Get()->GetGroups()->FindMyGroup(GetDialog()->GetParticipant())->GetId()));
  m_label_time_left = new Wt::WLabel(
    (std::string("Time left: ")
    + boost::lexical_cast<std::string>(Server::Get()->GetTimeLeft())
    + std::string(" seconds ")).c_str());
  m_text_chat = new Wt::WTextArea;

  assert(m_label_status);
  assert(m_label_id);
  assert(m_label_group);
  assert(m_label_time_left);
  assert(m_edit_chat);
  assert(m_text_chat);

  dialog->setContentAlignment(Wt::AlignCenter);
  dialog->addWidget(new Wt::WBreak);
  dialog->addWidget(m_label_status);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_id);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_group);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_time_left);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_edit_chat);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_text_chat);

  m_edit_chat->setMinimumSize(600,Wt::WLength::Auto);
  m_text_chat->setMinimumSize(600,600);
  m_text_chat->setReadOnly(true);
  m_edit_chat->enterPressed().connect(
    this,&ParticipantDialogStateChat::SubmitChatText);

  m_text_chat->setStyleClass("read_only_textarea");

}
//---------------------------------------------------------------------------
void ParticipantDialogStateChat::SubmitChatText()
{
  assert(m_edit_chat);
  assert(GetDialog()->CanGetParticipant()
    && "When the dialog in in the chatting state, there should be a participant");

  if (m_edit_chat->text().empty()) return;

  const std::string s
    = boost::lexical_cast<std::string>(GetDialog()->GetParticipant()->GetChatTag())
    + std::string(": ")
    + m_edit_chat->text().toUTF8();
  m_edit_chat->setText(GetRandomDebugString().c_str());

  assert(Server::Get());
  assert(Server::Get()->GetStateChat());

  Server::Get()->GetStateChat()->NotifyChatMessage(
    GetDialog()->GetParticipant(),s);
}
//---------------------------------------------------------------------------
