//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
//---------------------------------------------------------------------------
#include <boost/numeric/conversion/cast.hpp>
#include <boost/foreach.hpp>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WButtonGroup>
#include <Wt/WGroupBox>
#include <Wt/WLabel>
#include <Wt/WPushButton>
#include <Wt/WRadioButton>
//---------------------------------------------------------------------------
#include "chooseactionoption.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "state.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstate.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "participantdialog.h"
#include "participantdialogstate.h"
#include "participantdialogstatechooseaction.h"
//---------------------------------------------------------------------------
ParticipantDialogStateChooseAction::ParticipantDialogStateChooseAction(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog),
    m_button_choose_action(0),
    m_group(0),
    m_label_status(0),
    m_label_time_left(0)
{
  assert(!m_button_choose_action);
  assert(!m_group);
  assert(!m_label_status);
  assert(!m_label_time_left);
}
//---------------------------------------------------------------------------
///Do something random with the UI, used by DebugDialog
void ParticipantDialogStateChooseAction::DoSomethingRandom()
{
  switch (std::rand() % 5)
  {
    //Select a random button
    case 0:
      if (m_group->buttons()[0]->isEnabled())
      {
        m_group->setSelectedButtonIndex(
          -1 + (std::rand() % (m_group->count() + 1)));
      }
      break;
    //Click to choose this action
    case 1:
      if (m_button_choose_action->isEnabled())
      {
        OnChooseActionClick();
      }
      break;
    default: break; //No problem
  }
}
//---------------------------------------------------------------------------
void ParticipantDialogStateChooseAction::OnChooseActionClick()
{
  const int action_index = m_group->selectedButtonIndex();

  ///Check if user did not click vote, without selecting a radiobutton
  if (action_index == -1) return;

  ///Disallow a Participant to do two actions
  //if (GetDialog()->GetParticipant()->HasChosenAction())
  //{
  //  return;
  //}

  //assert(!GetDialog()->GetParticipant()->HasChosenAction());
  assert(action_index < boost::numeric_cast<int>(
    Server::Get()->GetParameters()->GetChooseAction()->GetOptions().size()));

  Server::Get()->GetStateChooseAction()->NotifyChosenAction(
    GetDialog()->GetParticipant(),
    Server::Get()->GetParameters()->GetChooseAction()->GetOptions()[action_index].get());
  //GetDialog()->GetParticipant()->ChooseAction(action_index);


  //assert(GetDialog()->GetParticipant()->HasChosenAction());

  ///Log the action
  //Server::Get()->GetLog()->LogAction(GetDialog()->GetParticipant());
  this->m_button_choose_action->setEnabled(false);
  BOOST_FOREACH(Wt::WRadioButton * const r,m_group->buttons())
  {
    r->setEnabled(false);
  }

}
//---------------------------------------------------------------------------
void ParticipantDialogStateChooseAction::OnTimer()
{
  assert(Server::Get());

  const int time_left = Server::Get()->GetTimeLeft();

  //Update label_time_left
  {
    std::string text
    =  std::string("Time left: ")
    + boost::lexical_cast<std::string>(time_left)
    + std::string(" seconds");
    if (Server::Get()->GetParameters()->GetChooseAction()->GetWait())
    {
      //Infinite time
      text+=std::string(" (waiting for others)");
    }
    assert(m_label_time_left);
    m_label_time_left->setText(text.c_str());
  }

  //Check if choice must be sent to the server
  if (!Server::Get()->GetParameters()->GetChooseAction()->GetWait()
    && time_left <= 0)
  {
    assert(GetDialog());
    assert(GetDialog()->CanGetParticipant());
    if (m_button_choose_action->isEnabled())
    {
      //Let Participant choose a random action by time
      const int selected = m_group->selectedButtonIndex();
      assert(m_group->count() > 0);
      const int action_index
        = (selected == -1 //Did user select something?
        ? std::rand() % m_group->count() //Take a random action
        : selected);
      m_group->setSelectedButtonIndex(action_index);
      //GetDialog()->GetParticipant()->ChooseAction(action_index);

      assert(action_index < boost::numeric_cast<int>(
        Server::Get()->GetParameters()->GetChooseAction()->GetOptions().size()));

      Server::Get()->GetStateChooseAction()->NotifyChosenAction(
        GetDialog()->GetParticipant(),
        Server::Get()->GetParameters()->GetChooseAction()->GetOptions()[action_index].get());

      m_button_choose_action->setEnabled(false);
      m_button_choose_action->refresh();
    }
  }


  if (!m_button_choose_action->isEnabled())
  {
    assert(m_group->selectedButtonIndex() != -1);
    const std::string choose_action_description
      = m_group->selectedButton()->text().toUTF8();
    const std::string text
      = std::string("You have chosen an action \'")
      + choose_action_description
      + std::string("\', waiting for the others...");

    m_label_status->setText(text.c_str());
  }
  else
  {
    m_label_status->setText("Please choose an action.");
  }

  ///Follow the server its tempo
  RespondToParticipant();
}
//---------------------------------------------------------------------------
void ParticipantDialogStateChooseAction::ShowPage()
{
  ParticipantDialog * const dialog = GetDialog();
  assert(dialog);

  dialog->clear(); //Wt deletes all dialog's child widgets

  assert(GetDialog()->CanGetParticipant()
    && "Assume a logged in participant");

  m_button_choose_action = new Wt::WPushButton("Choose selected action");
  m_group = new Wt::WButtonGroup(dialog);
  m_label_status = new Wt::WLabel("Please choose an action.");
  m_label_time_left = new Wt::WLabel("Time left: ... seconds");

  assert(m_button_choose_action);
  assert(m_group);
  assert(m_label_status);
  assert(m_label_time_left);

  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_status);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_time_left);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  //ButtonGroup
  {
    Wt::WGroupBox * const container = new Wt::WGroupBox("Possible actions",dialog);

    const std::vector<boost::shared_ptr<ChooseActionOption> >& options
      = Server::Get()->GetParameters()->GetChooseAction()->GetOptions();
    const int n_options
      = boost::numeric_cast<int>(options.size());
    //Add the RadioButtons
    for (int i=0; i!=n_options; ++i)
    {
      Wt::WRadioButton * const button = new Wt::WRadioButton(
        options[i]->GetDescription().c_str(), container);
      new Wt::WBreak(container);
      m_group->addButton(button,i);
    }
  }
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_button_choose_action);

  m_button_choose_action->clicked().connect(
    this,
    &ParticipantDialogStateChooseAction::OnChooseActionClick);

}
//---------------------------------------------------------------------------
