//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WLabel>
//---------------------------------------------------------------------------
#include "group.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "participantdialog.h"
#include "participantdialogstate.h"
#include "participantdialogstatechat.h"
#include "participantdialogstategroupdynamics.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "state.h"
#include "stopwatch.h"
//---------------------------------------------------------------------------
ParticipantDialogStateGroupDynamics::ParticipantDialogStateGroupDynamics(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog),
    m_label_status(0)
{

}
//---------------------------------------------------------------------------
void ParticipantDialogStateGroupDynamics::OnTimer()
{
  assert(GetDialog()->CanGetParticipant()
    && "Assume that only existing participants can have their payoffs assigned");

  //Is the Participant waiting to be assigned to a group,
  //that is: in GroupNotLoggedIn?
  if (Server::Get()->GetGroups()->FindMyGroup(GetDialog()->GetParticipant())
    == Server::Get()->GetGroups()->GetGroupLoggedIn())
  {
    //Can the server assign the Participant to a group?
    if (Server::Get()->GetStateGroupDynamics()->CanAssignGroup(GetDialog()->GetParticipant()))
    {
      //Assign the Participant to a group
      Server::Get()->GetStateGroupDynamics()->AssignGroup(GetDialog()->GetParticipant());

      assert(Server::Get()->GetGroups()->FindMyGroup(GetDialog()->GetParticipant())
        != Server::Get()->GetGroups()->GetGroupLoggedIn());

      //assert(GetDialog()->GetParticipant()->IsParticipating());
    }
  }

  {
    const Group * const group
      = Server::Get()->GetGroups()->FindMyGroup(GetDialog()->GetParticipant());
    //Update the status label
    const std::string message
      = Server::Get()->GetParameters()->GetGroupDynamics()->GetMessageAssigned()
      + boost::lexical_cast<std::string>(group->GetId())
      + (dynamic_cast<const GroupNotLoggedIn *>(group)
        ? std::string(" (not participating)")
        : std::string(" (participating)"));

    assert(m_label_status);
    m_label_status->setText(message.c_str());
  }
  //else
  //{
  //  const std::string message = Server::Get()->GetParameters()->GetGroupDynamics()->GetMessageUnassigned();
  //  m_label_status->setText(message.c_str());
  //}

  ///Follow the server its tempo
  RespondToParticipant();
}
//---------------------------------------------------------------------------
///Change the Participant's State to this ParticipantDialogState's State
/*
void ParticipantDialogStateGroupDynamics::SetParticipantState()
{
  assert(GetDialog());
  assert(GetDialog()->CanGetParticipant());
  GetDialog()->GetParticipant()->GetState()->SetState(State::group_dynamics);
}
*/
//---------------------------------------------------------------------------
void ParticipantDialogStateGroupDynamics::ShowPage()
{
  ParticipantDialog * const dialog = GetDialog();
  assert(dialog);

  assert(GetDialog()->CanGetParticipant()
    && "A Participant must be logged in in this state");

  assert(GetDialog()->GetParticipant()->CanGetId()
    && "A Participant must be assigned an ID before entering this state");

  dialog->clear(); //Wt deletes all dialog's child widgets

  //Create the widget(s)
  m_label_status = new Wt::WLabel;

  //Check the widget(s)
  assert(m_label_status);

  dialog->setContentAlignment(Wt::AlignCenter);
  dialog->addWidget(new Wt::WBreak);
  dialog->addWidget(new Wt::WBreak);
  {
    const std::string id
      = "You have been assigned ID "
      + boost::lexical_cast<std::string>(this->GetDialog()->GetParticipant()->GetId());
    dialog->addWidget(new Wt::WLabel(id.c_str()));
  }
  dialog->addWidget(new Wt::WBreak);
  dialog->addWidget(new Wt::WBreak);
  const Group * const group = Server::Get()->GetGroups()->FindMyGroup(GetDialog()->GetParticipant());

  if (const GroupParticipating * const ptr = dynamic_cast<const GroupParticipating*>(group))
  {
    const std::string message
      = Server::Get()->GetParameters()->GetGroupDynamics()->GetMessageAssigned()
      + boost::lexical_cast<std::string>(ptr->GetId());
    assert(m_label_status);
    m_label_status->setText(message.c_str());
  }
  else
  {
    const std::string message = Server::Get()->GetParameters()->GetGroupDynamics()->GetMessageUnassigned();
    assert(m_label_status);
    m_label_status->setText(message.c_str());
  }
  dialog->addWidget(m_label_status);
}
//---------------------------------------------------------------------------
//const std::string ParticipantDialogStateGroupDynamics::ToStr() const
//{
//  return State::StateToStr(State::group_dynamics);
//}
//---------------------------------------------------------------------------

