//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WCheckBox>
#include <Wt/WLabel>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "participantdialog.h"
#include "participantdialogstategroupdynamics.h"
#include "participantdialogstateloggedin.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
ParticipantDialogStateLoggedIn::ParticipantDialogStateLoggedIn(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog)
{

}
//---------------------------------------------------------------------------
/*
void ParticipantDialogStateLoggedIn::Login()
{
  assert(m_check_participate->isChecked()
    && Server::Get()->GetGroups()->CanLetLogin(
      GetDialog()->GetIpAddress()));

  assert(!GetDialog()->CanGetParticipant()
    && "Assume no logged in participants yet...");

  //The Participant is acknowledged to be logged in
  GetDialog()->SetParticipant(
    Server::Get()->LoginParticipant(GetDialog()->GetIpAddress()));

  assert(GetDialog()->CanGetParticipant()
    && "Assume a logged in participant");

  m_check_participate->hide();
  m_label_status->setText("Logged in... waiting for the experiment to start");

  //GetDialog()->SetState(GetDialog()->GetStateGroupDynamics());
}
*/
//---------------------------------------------------------------------------
void ParticipantDialogStateLoggedIn::OnTimer()
{
  /*
  if(!GetDialog()->CanGetParticipant())
  {
    //Check if participant may log in...
    if (m_check_participate->isChecked()
      && Server::Get()->GetGroups()->CanLetLogin(
        GetDialog()->GetIpAddress()))
    {
      Login();
    }
  }
  else
  {
  */
  //Participant is logged in
  ///Wait until the Server assigns the Participant to the GroupParticipating
    RespondToParticipant();
  //}
}
//---------------------------------------------------------------------------
///This method does nothing: waiting denotes unassigned
/*
void ParticipantDialogStateLoggedIn::SetParticipantState()
{
  assert(GetDialog());
  //assert(GetDialog()->CanGetParticipant());
  //GetDialog()->GetParticipant()->GetState()->SetState(ExperimentState::waiting);

}
*/
//---------------------------------------------------------------------------
void ParticipantDialogStateLoggedIn::ShowPage()
{
  assert(GetDialog());
  assert(GetDialog()->GetParticipant());
  assert(GetDialog()->GetParticipant()->CanGetId()
    && "A Participant must have became an ID before being logged in");
  assert(GetDialog()->GetParticipant()->CanGetIpAddress()
    && "A Participant must have became an IP address before being logged in");

  ParticipantDialog * const dialog = GetDialog();

  dialog->clear(); //Wt deletes all dialog's child widgets


  dialog->setContentAlignment(Wt::AlignCenter);
  new Wt::WBreak(dialog);
  new Wt::WLabel("Welcome logged-in participant.",dialog);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  new Wt::WLabel(
      (std::string("You have been assigned an ID of ")
    + boost::lexical_cast<std::string>(GetDialog()->GetParticipant()->GetId())).c_str()
    ,dialog);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
}
//---------------------------------------------------------------------------
