//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <iostream>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WCheckBox>
#include <Wt/WLabel>
//---------------------------------------------------------------------------
#include "groups.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "state.h"
#include "logfile.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "participantdialog.h"
#include "participantdialogstategroupdynamics.h"
#include "participantdialogstatenotloggedin.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
ParticipantDialogStateNotLoggedIn::ParticipantDialogStateNotLoggedIn(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog),
    m_check_participate(0),
    m_label_status(0)
{

}
//---------------------------------------------------------------------------
///Do something random with the UI, used by DebugDialog
void ParticipantDialogStateNotLoggedIn::DoSomethingRandom()
{
  switch (std::rand() % 5)
  {
    //Select a random button
    case 0: m_check_participate->setChecked(std::rand() % 2);
    default: break; //No problem
  }
}
//---------------------------------------------------------------------------
void ParticipantDialogStateNotLoggedIn::Login()
{
  //std::clog << "ParticipantDialogStateNotLoggedIn::Login()\n";

  assert(m_check_participate->isChecked()
    && Server::Get()->GetGroups()->CanLetLogin(GetDialog()->GetIpAddress()));

  assert(!GetDialog()->CanGetParticipant()
    && "Assume no logged in participants yet...");

  assert(Server::Get()->GetGroups()->CanLetLogin(GetDialog()->GetIpAddress()));

  //The Participant is acknowledged to be logged in
  GetDialog()->SetParticipant(
    Server::Get()->LetLogin(GetDialog()->GetIpAddress()));

  assert(GetDialog()->CanGetParticipant()
    && "Assume a logged in participant");

  assert(!Server::Get()->GetGroups()->GetGroupNotLoggedIn()->IsMember(
    GetDialog()->GetParticipant())
    && "Assume Participant is not in GroupNotLoggedIn anymore");

  assert(Server::Get()->GetGroups()->GetGroupLoggedIn()->IsMember(
    GetDialog()->GetParticipant())
    && "Assume Participant is in GroupLoggedIn");

  m_check_participate->hide();
  m_label_status->setText("Logged in... waiting for the experiment to start");

  //GetDialog()->SetState(GetDialog()->GetStateGroupDynamics());
}
//---------------------------------------------------------------------------
void ParticipantDialogStateNotLoggedIn::OnTimer()
{
  if(!GetDialog()->CanGetParticipant())
  {
    //Check if participant may log in...
    if (m_check_participate->isChecked()
      && Server::Get()->GetGroups()->CanLetLogin(
        GetDialog()->GetIpAddress()))
    {
      Login();
    }
  }
  else
  {
    //Participant is logged in
    ///Follow the server its tempo
    RespondToParticipant();
  }
}
//---------------------------------------------------------------------------
///This method does nothing: waiting denotes unassigned
/*
void ParticipantDialogStateNotLoggedIn::SetParticipantState()
{
  assert(GetDialog());
  //assert(GetDialog()->CanGetParticipant());
  //GetDialog()->GetParticipant()->GetState()->SetState(ExperimentState::waiting);

}
*/
//---------------------------------------------------------------------------
void ParticipantDialogStateNotLoggedIn::ShowPage()
{
  ParticipantDialog * const dialog = GetDialog();
  assert(dialog);

  dialog->clear(); //Wt deletes all dialog's child widgets

  m_check_participate = new Wt::WCheckBox("I want to participate");
  m_label_status = new Wt::WLabel("Welcome participant. Please wait for your assignment...");

  dialog->setContentAlignment(Wt::AlignCenter);
  dialog->addWidget(new Wt::WBreak);
  dialog->addWidget(m_label_status);

  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_check_participate);
}
//---------------------------------------------------------------------------
