//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <fstream>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WLabel>
#include <Wt/WTextArea>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "participantdialog.h"
#include "participantdialogstateviewresultsvoting.h"
//---------------------------------------------------------------------------
ParticipantDialogStateViewResultsVoting::ParticipantDialogStateViewResultsVoting(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog),
    m_label_time_left(0),
    m_text_area(0)
{

}
//---------------------------------------------------------------------------
void ParticipantDialogStateViewResultsVoting::OnTimer()
{
  assert(GetDialog()->CanGetParticipant()
    && "Assume that only existing participants can have finished an experiment");

  assert(Server::Get());

  const int time_left = Server::Get()->GetTimeLeft();

  //Update label_time_left
  {
    const std::string text
    =  std::string("Time left: ")
    + boost::lexical_cast<std::string>(time_left)
    + std::string(" seconds ");
    assert(m_label_time_left);
    m_label_time_left->setText(text.c_str());
  }

  ///Follow the server its tempo
  RespondToParticipant();
}
//---------------------------------------------------------------------------
void ParticipantDialogStateViewResultsVoting::ShowPage()
{
  ParticipantDialog * const dialog = GetDialog();
  assert(dialog);

  dialog->clear(); //Wt deletes all dialog's child widgets

  m_label_time_left = new Wt::WLabel;
  m_text_area = new Wt::WTextArea;

  dialog->setContentAlignment(Wt::AlignCenter);
  dialog->addWidget(m_label_time_left);
  dialog->addWidget(new Wt::WBreak);
  dialog->addWidget(new Wt::WBreak);
  dialog->addWidget(m_text_area);

  m_text_area->setMinimumSize(600,300);
  m_text_area->setReadOnly(true);

  assert(Server::Get());
  assert(Server::Get()->GetStateChooseAction());

  const std::vector<std::string> v
    = Server::Get()->GetStateViewResultsVoting()->GetResults(
      dialog->GetParticipant());
  std::string text;
  BOOST_FOREACH(const std::string& s,v)
  {
    text+=s+'\n';
  }
  assert(!text.empty());
  //pop the trailing newline
  text.resize(text.size()-1);
  m_text_area->setText(text.c_str());
  m_text_area->setStyleClass("read_only_textarea");
}
//---------------------------------------------------------------------------
