//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/numeric/conversion/cast.hpp>
//---------------------------------------------------------------------------
#include <Wt/WBreak>
#include <Wt/WButtonGroup>
#include <Wt/WGroupBox>
#include <Wt/WLabel>
#include <Wt/WPushButton>
#include <Wt/WRadioButton>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "participantdialog.h"
#include "participantdialogstatevoting.h"
//---------------------------------------------------------------------------
ParticipantDialogStateVoting::ParticipantDialogStateVoting(
  ParticipantDialog * const dialog)
  : ParticipantDialogState(dialog),
    m_button_vote(0),
    m_group(0),
    m_label_time_left(0)
{
  assert(!m_button_vote);
  assert(!m_group);
  assert(!m_label_time_left);
}
//---------------------------------------------------------------------------
///Do something random with the UI, used by DebugDialog
void ParticipantDialogStateVoting::DoSomethingRandom()
{
  assert(m_group);
  assert(m_button_vote);

  switch (std::rand() % 5)
  {
    //Select a random button
    case 0:
      if (m_group->buttons()[0]->isEnabled())
      {
        m_group->setSelectedButtonIndex(
          -1 + (std::rand() % (m_group->count() + 1)));
      }
      break;
    //Click to choose this action
    case 1:
      if (m_button_vote->isEnabled())
      {
        OnVoteClick();
      }
      break;
    default: break; //No problem
  }
}
//---------------------------------------------------------------------------
void ParticipantDialogStateVoting::OnTimer()
{
  assert(Server::Get());

  const int time_left = Server::Get()->GetTimeLeft();

  //Update label_time_left
  {
    std::string text = std::string("Time left: ")
    + boost::lexical_cast<std::string>(time_left)
    + std::string(" seconds ");
    if (Server::Get()->GetParameters()->GetVoting()->GetWait())
    {
      //Infinite time
      text+=std::string(" (waiting for others)");
    }
    assert(m_label_time_left);
    m_label_time_left->setText(text.c_str());
  }

  //Check if choice must be sent to the server

  //If no waiting for others, choose randomly for the Participant
  if (!Server::Get()->GetParameters()->GetVoting()->GetWait()
    && time_left <= 0)
  {
    assert(GetDialog());
    assert(GetDialog()->CanGetParticipant());
    if (m_button_vote->isEnabled())
    {
      m_button_vote->setEnabled(false);
      assert(!m_button_vote->isEnabled());

      const int selected = m_group->selectedButtonIndex();
      assert(m_group->count() > 0);
      const int vote_index
        = (selected == -1 //Did user select something?
        ? std::rand() % m_group->count() //Take a random action
        : selected);
      m_group->setSelectedButtonIndex(vote_index);

      Server::Get()->GetStateVoting()->NotifyVote(
        GetDialog()->GetParticipant(),vote_index);

      //assert(GetDialog()->GetParticipant()->HasVoted());

      ///Log the vote
      Server::Get()->GetLog()->LogVote(GetDialog()->GetParticipant());
    }
  }

  if (!m_button_vote->isEnabled())
  {
    assert(m_group->selectedButtonIndex() != -1);
    const std::string vote_description
      = m_group->selectedButton()->text().toUTF8();
    const std::string text
      = std::string("You have voted \'")
      + vote_description
      + std::string("\', waiting for the others...");
    m_button_vote->setEnabled(false);
    m_label_status->setText(text.c_str());
  }
  else
  {
    m_label_status->setText("Waiting for your vote");
  }


  ///Follow the server its tempo
  RespondToParticipant();
}
//---------------------------------------------------------------------------
void ParticipantDialogStateVoting::OnVoteClick()
{
  const int vote = m_group->selectedButtonIndex();

  ///Check if user did not click vote, without selecting a radiobutton
  if (vote == -1) return;

  ///If Participant has already voted, return
  //if (GetDialog()->GetParticipant()->HasVoted())
  //{
  //  return;
  //}

  //assert(!GetDialog()->GetParticipant()->HasVoted());

  //Do really vote
  Server::Get()->GetStateVoting()->NotifyVote(
    GetDialog()->GetParticipant(),
    vote);

  //assert(GetDialog()->GetParticipant()->HasVoted());
  m_button_vote->setEnabled(false);

  BOOST_FOREACH(Wt::WRadioButton * const r,m_group->buttons())
  {
    r->setEnabled(false);
  }

}
//---------------------------------------------------------------------------
/*
///Change the Participant's State to this ParticipantDialogState's State
void ParticipantDialogStateVoting::SetParticipantState()
{
  assert(GetDialog());
  assert(GetDialog()->CanGetParticipant());
  assert(GetDialog()->GetParticipant()->IsParticipating()
    && "Only partipating Participants can vote");
  GetDialog()->GetParticipant()->GetState()->SetState(State::voting);
}
*/
//---------------------------------------------------------------------------
void ParticipantDialogStateVoting::ShowPage()
{
  ParticipantDialog * const dialog = GetDialog();
  assert(dialog);

  dialog->clear(); //Wt deletes all dialog's child widgets

  assert(GetDialog()->CanGetParticipant()
    && "Assume a logged in participant");

  m_button_vote = new Wt::WPushButton("Vote");
  m_group = new Wt::WButtonGroup(dialog);
  m_label_time_left = new Wt::WLabel("Time left: ... seconds");
  m_label_status = new Wt::WLabel("Waiting for your vote");

  assert(m_button_vote);
  assert(m_group);
  assert(m_label_time_left);
  assert(m_label_status);

  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_status);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_label_time_left);
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  //ButtonGroup
  {
    Wt::WGroupBox * const container = new Wt::WGroupBox("Possible voting options",dialog);

    const std::vector<std::string> descriptions
      = Server::Get()->GetParameters()->GetVoting()->GetVoteDescriptions();
    const int n_descriptions
      = boost::numeric_cast<int>(descriptions.size());
    //Add the RadioButtons
    for (int i=0; i!=n_descriptions; ++i)
    {
      Wt::WRadioButton * const button = new Wt::WRadioButton(descriptions[i].c_str(), container);
      new Wt::WBreak(container);
      m_group->addButton(button,i);
    }
  }
  new Wt::WBreak(dialog);
  new Wt::WBreak(dialog);
  dialog->addWidget(m_button_vote);

  m_button_vote->clicked().connect(
    this,
    &ParticipantDialogStateVoting::OnVoteClick);
}
//---------------------------------------------------------------------------
