//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
//---------------------------------------------------------------------------
#include "participantstate.h"
//---------------------------------------------------------------------------
ParticipantState::ParticipantState(Participant * const participant)
  : m_participant(participant)
{
  assert(m_participant);
}
//---------------------------------------------------------------------------

/*
  std::string s = "#";
  if (!CanGetId())
  {
    s+="?: waiting for login";
    return s;
  }
  s+=boost::lexical_cast<std::string>(GetId());
  s+=", group #";
  if (!CanGetGroup())
  {
    s+="?: no group assigned yet";
    return s;
  }
  s+=boost::lexical_cast<std::string>(GetGroup());
  s+=": ";
  switch (GetState()->GetState())
  {
    case State::chat:
    {
      if (!CanGetLastChat())
      {
        s+="no last chat";
        return s;
      }
      if (!HasChatted())
      {
        s+="not chatted";
        return s;
      }
      s+=std::string("has last chatted: ")
        +boost::lexical_cast<std::string>(
          this->GetLastChat().back());
      return s;
    }
    case State::choose_action:
    {
      if (!CanGetLastAction())
      {
        s+="no last action chosen";
        return s;
      }
      if (!HasChosenAction())
      {
        s+="no action chosen";
        return s;
      }
      s+=std::string("has chosen action ")
        +boost::lexical_cast<std::string>(
          this->GetLastChosenAction());
      return s;
    }
    case State::finished:
    {
      s+="finished";
      return s;
    }
    case State::group_dynamics:
    {
      s+="group dynamics";
      return s;
    }
    case State::view_results_all:
    {
      s+="view results all";
      return s;
    }
    case State::view_results_group:
    {
      s+="view results group";
      return s;
    }
    case State::view_results_voting:
    {
      s+="view results group";
      return s;
    }
    case State::voting:
    {
      if (!CanGetLastVote())
      {
        s+="no last vote done";
        return s;
      }
      if (!HasVoted())
      {
        s+="not voted";
        return s;
      }
      s+=std::string("has voted ")
        +boost::lexical_cast<std::string>(
          this->GetLastVote());
      return s;
    }
    case State::undefined:
    {
      s+="undefined";
      return s;
    }
    case State::not_logged_in:
    {
      //An Administrator or Participant can be not logged in
      s+="not logged in";
    }
    case State::waiting:
    {
      //A server can wait for a parameter file
      assert(!"Participants cannot wait for a parameter file");
      s+="waiting";
    }
  }
  assert(!"Should not get here");
  s+="SHOULD NOT GET HERE";
  return s;
*/
