//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "participant.h"
#include "participantstateassignpayoff.h"
//---------------------------------------------------------------------------
ParticipantStateAssignPayoff::ParticipantStateAssignPayoff(Participant * const participant)
  : ParticipantState(participant)
{

}
//---------------------------------------------------------------------------
const std::string ParticipantStateAssignPayoff::ToAdminStr() const
{
  const Participant * const participant = GetParticipant();
  std::string s
    = boost::lexical_cast<std::string>(participant->GetId())
    + std::string(": ");
  const std::vector<double>& payoffs = participant->GetPayoffs();
  if (payoffs.empty())
  {
    s+="no payoffs assigned";
    return s;
  }
  else
  {
    s +=boost::lexical_cast<std::string>(payoffs.size())
      + std::string(" payoffs, last: ")
      + boost::lexical_cast<std::string>(payoffs.back());
  }
  return s;
}
//---------------------------------------------------------------------------
