//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "chooseactionoption.h"
#include "participant.h"
#include "participantstatechooseaction.h"
//---------------------------------------------------------------------------
ParticipantStateChooseAction::ParticipantStateChooseAction(Participant * const participant)
  : ParticipantState(participant)
{

}
//---------------------------------------------------------------------------
const std::string ParticipantStateChooseAction::ToAdminStr() const
{
 const Participant * const participant = GetParticipant();

  std::string s
    = boost::lexical_cast<std::string>(participant->GetId())
    + std::string(": ")
    + this->ToStr()
    + std::string(": ");
  if (!participant->GetActions().empty())
  {
    BOOST_FOREACH(const ChooseActionOption * action,participant->GetActions())
    {
      s+=action->GetDescription()+",";
      //s+=boost::lexical_cast<std::string>(i)+",";
    }
    s.resize(s.size() - 1);
    s += std::string("(")
      + boost::lexical_cast<std::string>(participant->GetActions().size())
      + std::string(")");
  }
  else
  {
    s+="no actions chosen";
  }
  return s;

}
//---------------------------------------------------------------------------

