//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <fstream>
//#include <iostream>
#include <map>
//---------------------------------------------------------------------------
#include <boost/bind.hpp>
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/numeric/conversion/cast.hpp>
//---------------------------------------------------------------------------
#include "administrator.h"
#include "group.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "repeatassigner.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "votingoption.h"
//---------------------------------------------------------------------------
ServerStateAssignPayoff::ServerStateAssignPayoff(
  Server * const server)
  : ServerState(server)
{

}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateAssignPayoff::CanGoToNextState() const
{
  return true;
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateAssignPayoff::GetStateDuration() const
{
  return this->GetMaxInt();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateAssignPayoff::GoToNextState() const
{
  GetServer()->SetState(GetServer()->GetStateViewResultsGroup());
}
//---------------------------------------------------------------------------
void ServerStateAssignPayoff::OnTimer()
{
  if (CanGoToNextState()) GoToNextState();
}
//---------------------------------------------------------------------------
void ServerStateAssignPayoff::SetParameters(const ParametersAssignPayoff* const parameters)
{
  assert(parameters);
  //Nothing to do yet
  m_parameters = parameters;
}
//---------------------------------------------------------------------------
void ServerStateAssignPayoff::Start()
{
  ///assigns all Participant payoffs
  BOOST_FOREACH(const Group * const g,
    GetServer()->GetGroups()->CollectGroups(false,false,true,false))
  {
    assert(g);
    assert(GetServer()->GetStateViewResultsVoting()->GetVotedOptions().find(
      g) != GetServer()->GetStateViewResultsVoting()->GetVotedOptions().end());
    const VotingOption * const option
      = GetServer()->GetStateViewResultsVoting()->GetVotedOptions().find(g)->second;
    assert(option);

    FindGroup(g)->AssignPayoff(option);
  }

  BOOST_FOREACH(const Participant * const p,
    GetServer()->GetGroups()->CollectParticipants(false,false,true,false))
  {
    StateAssignPayoff * const state
      = dynamic_cast<const StateAssignPayoff*>(this);
    assert(state);
    FindParticipant(p)->SetState(state);
  }
}
//---------------------------------------------------------------------------
