//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <fstream>
//---------------------------------------------------------------------------
#include <boost/bind.hpp>
#include <boost/foreach.hpp>
//#include <boost/lambda/lambda.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "administrator.h"
#include "group.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "state.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "state.h"
#include "trace.h"
//---------------------------------------------------------------------------
ServerStateChat::ServerStateChat(
  Server * const server)
  : ServerState(server),
    m_parameters(0)
{

}
//---------------------------------------------------------------------------
///See if the Participant has pending chat messages,
///sent by him/herself or the others
bool ServerStateChat::CanGetChatMessages(
  const Participant * const participant) const
{
  TRACE_FUNC();

  assert(participant);
  return m_chat_messages.find(participant) != m_chat_messages.end();
}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateChat::CanGoToNextState() const
{
  TRACE_FUNC();

  return GetTimeLeft() < 0;
}
//---------------------------------------------------------------------------
///Checks if each Participant has chatted already this/last round
//bool ServerStateChat::GetAllParticipantsHaveChatted() const
//{
  //const std::vector<const Participant *> v
  //  = GetServer()->CollectActiveParticipants();

  //return std::find_if(
  //  v.begin(),v.end(),
  //  std::not1(boost::mem_fn(&Participant::HasChatted))
  //  ) == v.end();
//}
//---------------------------------------------------------------------------
///Obtain the Participant his/her pending chat messages,
///sent by him/herself or the others
const std::vector<std::string> ServerStateChat::GetChatMessages(
  const Participant * const participant)
{
  TRACE_FUNC();

  assert(CanGetChatMessages(participant));
  //Get new messages
  const std::vector<std::string> messages = m_chat_messages[participant];
  //Remove pending messages
  m_chat_messages[participant].resize(0);
  //Return new messages
  return messages;
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateChat::GetStateDuration() const
{
  return m_parameters->GetDuration();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateChat::GoToNextState() const
{
  TRACE_FUNC();

  GetServer()->SetState(GetServer()->GetStateVoting());
}
//---------------------------------------------------------------------------
void ServerStateChat::OnTimer()
{
  TRACE_FUNC();

  if (CanGoToNextState()) GoToNextState();
}
//---------------------------------------------------------------------------
///In the 'Chat' phase, any Participant can send a chat message that
///will be broadcasted to all group members
void ServerStateChat::NotifyChatMessage(
  const Participant * const participant,
  const std::string& message)
{
  TRACE_FUNC();
  //#ifdef Server_USE_MUTEX
  //boost::mutex::scoped_lock lock(m_mutex);
  //#endif

  assert(GetServer());

  LogFile * const logfile = GetServer()->GetLog();
  assert(logfile);

  TRACE("(1) ServerStateChat::NotifyChatMessage");

  //Append the chat message to the Participant his/her own log
  FindParticipant(participant)->AppendChat(message);

  TRACE("(2) ServerStateChat::NotifyChatMessage");

  //Logging this event
  logfile->LogChatMessage(participant,message);

  TRACE("(3) ServerStateChat::NotifyChatMessage");

  //Broadcasting chat texts for participants of the same group
  //including the sender itself
  {
    TRACE("(4) ServerStateChat::NotifyChatMessage");
    const Group * const group = GetServer()->GetGroups()->FindMyGroup(participant);

    BOOST_FOREACH(
      const Participant * const p,
      group->CollectParticipants())

    {
      TRACE("(5) ServerStateChat::NotifyChatMessage");
      m_chat_messages[p].push_back(message);
      TRACE("(6) ServerStateChat::NotifyChatMessage");
    }
  }

  TRACE("(7) ServerStateChat::NotifyChatMessage");
}
//---------------------------------------------------------------------------
void ServerStateChat::SetParameters(const ParametersChat* const parameters)
{
  assert(parameters);
  //m_state_time = parameters->GetDuration();
  //assert(m_state_time >= 0);
  m_parameters = parameters;

  ResetTimeLeft();
  assert(this->GetTimeLeft() >= 0);
}
//---------------------------------------------------------------------------
///Start or restart the state. Just go to the next chat phase, because
///every Participant can have or have not chatted the last round
void ServerStateChat::Start()
{
  TRACE_FUNC();

  ResetTimeLeft();
  m_chat_messages.clear();

  BOOST_FOREACH(
    const Participant * const p,
    this->GetServer()->GetGroups()->CollectParticipants(false,false,true,false))
  {
    StateChat * const state = dynamic_cast<const StateChat*>(this);
    assert(state);
    FindParticipant(p)->SetState(state);
    FindParticipant(p)->StartChat();
  }
}
//---------------------------------------------------------------------------
