//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <fstream>
#include <iostream>
//---------------------------------------------------------------------------
//#include <boost/bind.hpp>
#include <boost/foreach.hpp>
#include <boost/lambda/bind.hpp>
#include <boost/lambda/lambda.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "administrator.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "repeatassigner.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "trace.h"
//---------------------------------------------------------------------------
ServerStateChooseAction::ServerStateChooseAction(
  Server * const server)
  : ServerState(server),
    m_parameters(0)
{

}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateChooseAction::CanGoToNextState() const
{
  TRACE_FUNC();

  typedef std::pair<const Participant*,bool> Pair;
  BOOST_FOREACH(const Pair& p,m_has_chosen_action)
  {
    if (p.second == false) return false;
  }
  return true;
  /*
  //If there is no 'false' in m_has_voted::second
  return std::find_if(
    m_has_chosen_action.begin(),
    m_has_chosen_action.end(),
      boost::lambda::bind(&std::pair<const Participant*,bool>::second, boost::lambda::_1)
      == false)
    == m_has_chosen_action.end();
  */
}
//---------------------------------------------------------------------------
///Checks if each Participant has choosen an action already this/last round
//Could have use lambda functions instead as well :-(
/*
bool ServerStateChooseAction::GetAllParticipantsHaveChosenAction() const
{
  const std::vector<const Participant *> v
    = GetServer()->CollectActiveParticipants();

  return std::find_if(
    v.begin(),v.end(),
    std::not1(boost::mem_fn(&Participant::HasChosenAction)))
      == v.end();
}
*/
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateChooseAction::GetStateDuration() const
{
  return m_parameters->GetDuration();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateChooseAction::GoToNextState() const
{
  TRACE_FUNC();

  GetServer()->SetState(GetServer()->GetStateAssignPayoff());
}
//---------------------------------------------------------------------------
///The Server is notified by ParticipantDialogChooseAction
///of the action taken by its Participant
void ServerStateChooseAction::NotifyChosenAction(
  const Participant * const participant,
  const ChooseActionOption * const option)
{
  assert(option);
  this->FindParticipant(participant)->ChooseAction(option);

  m_has_chosen_action[participant] = true;

  //Log the chosen action
  Server::Get()->GetLog()->LogAction(participant);
}
//---------------------------------------------------------------------------
void ServerStateChooseAction::OnTimer()
{
  TRACE_FUNC();

  if (CanGoToNextState())
  {
    #define DEBUG_762376438743879387487648436398364976587452134567
    #ifdef  DEBUG_762376438743879387487648436398364976587452134567
    typedef std::pair<const Participant *,bool> Pair;
    BOOST_FOREACH(const Pair& p,m_has_chosen_action)
    {
      std::clog << (p.first)->GetId() << ": " << p.second << '\n';

    }
    #endif
    GoToNextState();
  }
}
//---------------------------------------------------------------------------
void ServerStateChooseAction::SetParameters(const ParametersChooseAction* const parameters)
{
  assert(parameters);
  m_parameters = parameters;

  ResetTimeLeft();
  assert(this->GetTimeLeft() >= 0);
}
//---------------------------------------------------------------------------
void ServerStateChooseAction::Start()
{
  TRACE_FUNC();

  ///Keeps track of Participants having voted
  m_has_chosen_action.clear();
  assert(m_has_chosen_action.empty());

  BOOST_FOREACH(
    const Participant * const p,
    GetServer()->GetGroups()->CollectParticipants(false,false,true,false))
  {
    assert(!GetServer()->GetGroups()->CollectParticipants(false,false,true,false).empty());
    assert(p);
    m_has_chosen_action.insert(std::make_pair(p,false));
    StateChooseAction * const state = dynamic_cast<const StateChooseAction*>(this);
    assert(state);
    FindParticipant(p)->SetState(state);
  }
  assert(!CanGoToNextState());
}
//---------------------------------------------------------------------------
