//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "group.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
ServerStateFinished::ServerStateFinished(
  Server * const server)
  : ServerState(server)
{

}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateFinished::CanGoToNextState() const
{
  return false;
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateFinished::GetStateDuration() const
{
  //assert(m_parameters);
  //return m_parameters->GetDuration();
  return this->GetMaxInt();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateFinished::GoToNextState() const
{
  //There is no next state
}
//---------------------------------------------------------------------------
void ServerStateFinished::OnTimer()
{
  //Do exactly nothing
}
//---------------------------------------------------------------------------
void ServerStateFinished::SetParameters(const ParametersFinished* const parameters)
{
  assert(parameters);

  //No parameters yet...
}
//---------------------------------------------------------------------------
void ServerStateFinished::Start()
{
  BOOST_FOREACH(
    const Participant * const p,
    this->GetServer()->GetGroups()->CollectParticipants())
  {
    FindParticipant(p)->SetState(new StateFinished);
  }

  GetServer()->GetGroups()->MoveAllToFinished();
}
//---------------------------------------------------------------------------
