//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "chooseactionoption.h"
#include "group.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "repeatassigner.h"
#include "state.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
ServerStateViewResultsGroup::ServerStateViewResultsGroup(
  Server * const server)
  : ServerState(server),
    m_parameters(0),
    m_repeats_left(-1)
{

}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateViewResultsGroup::CanGoToNextState() const
{
  return GetTimeLeft() < 0;
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateViewResultsGroup::GetStateDuration() const
{
  return m_parameters->GetDuration();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateViewResultsGroup::GoToNextState() const
{
  if (CanGoToNextState())
  {
    if (m_repeats_left == 0)
    {
      GetServer()->SetState(GetServer()->GetStateViewResultsAll());
    }
    else
    {
      GetServer()->SetState(GetServer()->GetStateChooseAction());
    }
  }
}
//---------------------------------------------------------------------------
const std::vector<std::string> ServerStateViewResultsGroup::GetResults(
  const Participant * const participant) const
{
  assert(participant);
  assert(GetServer());
  assert(GetServer()->GetParameters());
  assert(GetServer()->GetParameters()->GetChooseAction());

  std::vector<std::string> v;
  v.push_back("Group results");
  v.push_back(" ");

  //assert(!participant->GetPayoffs().empty()
  const Group * const group = GetServer()->GetGroups()->FindMyGroup(participant);


  v.push_back(std::string("You are in group #")
    + boost::lexical_cast<std::string>(
      Server::Get()->GetGroups()->FindMyGroup(participant)->GetId()));

  if (!participant->GetPayoffs().empty())
  {
    v.push_back(std::string("Your last payoff is ")
      + boost::lexical_cast<std::string>(participant->GetPayoffs().back()));
    v.push_back(std::string("Your total payoff is ")
      + boost::lexical_cast<std::string>(participant->GetPayoffTotal()));
  }
  else
  {
    v.push_back("Your last payoff is [none]");
  }
  v.push_back(" ");

  BOOST_FOREACH(const Participant * const other,
    group->CollectParticipants())
  {
    if (!other->GetPayoffs().empty())
    {
      std::string s
        = boost::lexical_cast<std::string>(other->GetChatTag())
        + std::string(": ")
        + (other->GetActions().back()->GetContribution() != 0.0
          ? std::string("contributed")
          : std::string("did not contribute"))
        + ( other->GetId() == participant->GetId()
          ? std::string(" (YOUR ACTION)")
          : std::string(""));
      v.push_back(s);
    }
  }
  return v;
}
//---------------------------------------------------------------------------
void ServerStateViewResultsGroup::OnTimer()
{
  if (CanGoToNextState()) GoToNextState();
}
//---------------------------------------------------------------------------
void ServerStateViewResultsGroup::SetParameters(const ParametersViewResultsGroup* const parameters)
{
  assert(parameters);
  m_parameters = parameters;
  m_repeats_left = m_parameters->GetRepeatAssigner()->Assign();
  assert(m_repeats_left >= 0
    && "m_repeats must be zero or positive");

  ResetTimeLeft();
  assert(this->GetTimeLeft() >= 0);
}
//---------------------------------------------------------------------------
///Start or restart the state
void ServerStateViewResultsGroup::Start()
{
  assert(m_parameters);
  assert(m_repeats_left >= 0
    && "m_repeats must be zero or positive");
  if (m_repeats_left == 0)
  {
    m_repeats_left = m_parameters->GetRepeatAssigner()->Assign();
  }
  --m_repeats_left;
  assert(m_repeats_left >= 0
    && "m_repeats must be zero or positive");

  BOOST_FOREACH(const Participant * const p,
    GetServer()->GetGroups()->CollectParticipants(false,false,true,false))
  {
    StateViewResultsGroup * const state
      = dynamic_cast<const StateViewResultsGroup*>(this);
    assert(state);
    FindParticipant(p)->SetState(state);
  }

}
//---------------------------------------------------------------------------
