//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <algorithm>
#include <cassert>
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/lambda/bind.hpp>
#include <boost/lambda/lambda.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/numeric/conversion/cast.hpp>
#include <boost/shared_ptr.hpp>
//---------------------------------------------------------------------------
#include "group.h"
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "trace.h"
#include "votingoption.h"
//---------------------------------------------------------------------------
ServerStateViewResultsVoting::ServerStateViewResultsVoting(
  Server * const server)
  : ServerState(server),
    m_parameters(0)
{

}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateViewResultsVoting::CanGoToNextState() const
{
  TRACE_FUNC();
  return GetTimeLeft() < 0;
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateViewResultsVoting::GoToNextState() const
{
  TRACE_FUNC();
  GetServer()->SetState(GetServer()->GetStateChooseAction());
}
//---------------------------------------------------------------------------
const std::vector<std::string> ServerStateViewResultsVoting::GetResults(
  const Participant * const participant) const
{
  assert(participant);
  //assert(participant->HasAssignedPayoff());
  assert(GetServer());
  assert(GetServer()->GetParameters());
  assert(GetServer()->GetParameters()->GetVoting());


  const Group * const group
    = GetServer()->GetGroups()->FindMyGroup(participant);

  std::vector<std::string> v;
  v.push_back("Group voting results");
  v.push_back(" ");
  v.push_back(std::string("You are in group #")
    + boost::lexical_cast<std::string>(group->GetId()));
  v.push_back(" ");
  //Show vote of this Participant
  {
    if(!participant->GetVotes().empty())
    {
      const int vote_index = participant->GetVotes().back();
      assert(vote_index >= 0);
      assert(vote_index < boost::numeric_cast<int>(
        GetServer()->GetParameters()->GetVoting()->GetVoteDescriptions().size()));
      const std::string vote_description
        = GetServer()->GetParameters()->GetVoting()->GetVoteDescriptions()
          [vote_index];
      v.push_back(
        std::string("Your vote was \'")
        + vote_description
        + std::string("\'"));
    }
    else
    {
      v.push_back("Your had not voted...");
    }
  }
  v.push_back(" ");
  //View other's votes
  BOOST_FOREACH(const Participant * const other,
    group->CollectParticipants())
  {
    if(!other->GetVotes().empty())
    {
      const int vote_index = other->GetVotes().back();
      assert(vote_index >= 0);
      assert(vote_index < boost::numeric_cast<int>(
        GetServer()->GetParameters()->GetVoting()->GetVoteDescriptions().size()));
      const std::string vote_descriptor
        = GetServer()->GetParameters()->GetVoting()->GetVoteDescriptions()
          [vote_index];

      std::string s
        = boost::lexical_cast<std::string>(other->GetChatTag())
        + std::string(": ")
        + vote_descriptor
        + ( other->GetId() == participant->GetId()
          ? std::string(" (YOUR VOTE)")
          : std::string(""));
      v.push_back(s);
    }
    else
    {
      v.push_back("had not voted");
    }
  }
  v.push_back(" ");
  v.push_back(std::string("Group has voted for:"));
  {
    assert(GetVotedOptions().find(group) != GetVotedOptions().end());
    if (this->GetVotedOptions().find(group)->second != 0)
    {
      v.push_back(GetVotedOptions().find(group)->second->GetDescription());
    }
    else
    {
      v.push_back("No concensus reached");
    }
  }
  return v;
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateViewResultsVoting::GetStateDuration() const
{
  assert(m_parameters);
  return m_parameters->GetDuration();
}
//---------------------------------------------------------------------------
void ServerStateViewResultsVoting::OnTimer()
{
  TRACE_FUNC();
  if (CanGoToNextState()) GoToNextState();
}
//---------------------------------------------------------------------------
void ServerStateViewResultsVoting::SetParameters(
  const ParametersViewResultsVoting* const parameters)
{
  assert(parameters);
  m_parameters = parameters;
  ResetTimeLeft();
  assert(this->GetTimeLeft() >= 0);
}
//---------------------------------------------------------------------------
///Start or restart the state
void ServerStateViewResultsVoting::Start()
{
  TRACE_FUNC();
  ///Setting the group its vote
  m_voted_options.clear();

  BOOST_FOREACH(const Group * const group,
    GetServer()->GetGroups()->CollectGroups(false,false,true,false))
  {
    //Only participating groups will have voted
    assert(dynamic_cast<const GroupParticipating*>(group));

    TRACE(group->GetId());

    //Tally all votes
    std::map<int,int> vote_tally;
    BOOST_FOREACH(const Participant * const participant,
      group->CollectParticipants())
    {
      TRACE(participant->GetId());

      assert(!participant->GetVotes().empty());
      const int vote = participant->GetVotes().back();
      if (vote_tally.find(vote) == vote_tally.end())
      {
        TRACE(vote);
        vote_tally[vote] = 0;
      }
      else
      {
        ++vote_tally[vote];
        TRACE(vote_tally[vote]);
      }
    }

    //Get the highest tally value (that is: the second int)
    const std::map<int,int>::const_iterator max
      = std::max_element(
        vote_tally.begin(),
        vote_tally.end(),
        boost::lambda::bind(&std::pair<const int,int>::second, boost::lambda::_2)
         > boost::lambda::bind(&std::pair<const int,int>::second, boost::lambda::_1));
    TRACE(max->first);
    TRACE(max->second);
    const int max_count
      = std::count_if(
       vote_tally.begin(),
       vote_tally.end(),
       boost::lambda::bind(&std::pair<const int,int>::second, boost::lambda::_1)
         == max->second);
    TRACE(max_count);

    assert(max_count >= 1);
    if (max_count == 1)
    {
      //Unique!
      assert(max->first < boost::numeric_cast<int>(
        GetServer()->GetParameters()->GetVoting()->GetOptions().size()));
      m_voted_options[group]
        = GetServer()->GetParameters()->GetVoting()->GetOptions()[max->first].get();
      TRACE(group);
    }
    else
    {
      //No consensus in voting
      m_voted_options[group] = 0;
      TRACE(group);
    }

  }
  BOOST_FOREACH(const Participant * const p,
    GetServer()->GetGroups()->CollectParticipants(false,false,true,false))
  {
    StateViewResultsVoting * const state
      = dynamic_cast<const StateViewResultsVoting*>(this);
    assert(state);
    FindParticipant(p)->SetState(state);
  }
}
//---------------------------------------------------------------------------

