//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
//#include <iostream>
//---------------------------------------------------------------------------
//#include <boost/bind.hpp>
#include <boost/foreach.hpp>
#include <boost/lambda/bind.hpp>
#include <boost/lambda/lambda.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
#include "trace.h"
//---------------------------------------------------------------------------
ServerStateVoting::ServerStateVoting(
  Server * const server)
  : ServerState(server)
{

}
//---------------------------------------------------------------------------
///ServerStateVoting goes to the next state if
/// - all Participants are logged in
/// - all Participants have voted
bool ServerStateVoting::CanGoToNextState() const
{
  typedef std::pair<const Participant*,bool> Pair;
  BOOST_FOREACH(const Pair& p,m_has_voted)
  {
    if (p.second == false) return false;
  }
  return true;

  /*
  //If there is no 'false' in m_has_voted::second
  return std::find_if(
    m_has_voted.begin(),
    m_has_voted.end(),
      boost::lambda::bind(
        &std::pair<const Participant*,bool>::second,
        boost::lambda::_1) == false)
    == m_has_voted.end();
  */
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateVoting::GetStateDuration() const
{
  return m_parameters->GetDuration();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateVoting::GoToNextState() const
{
  GetServer()->SetState(GetServer()->GetStateViewResultsVoting());
}
//---------------------------------------------------------------------------
///ParticipantDialog notifies the Server of the
///Participant his/her vote
void ServerStateVoting::NotifyVote(
  const Participant * const participant,
  const int vote_index)
{
  FindParticipant(participant)->Vote(vote_index);

  m_has_voted[participant] = true;

  //Log the vote
  Server::Get()->GetLog()->LogVote(participant);

}
//---------------------------------------------------------------------------
void ServerStateVoting::OnTimer()
{
  if (CanGoToNextState()) GoToNextState();
}
//---------------------------------------------------------------------------
void ServerStateVoting::SetParameters(const ParametersVoting* const parameters)
{
  assert(parameters);
  m_parameters = parameters;
  //m_state_time = parameters->GetTime();
  //m_wait = parameters->GetWait();

  ResetTimeLeft();
  assert(this->GetTimeLeft() >= 0);
}
//---------------------------------------------------------------------------
void ServerStateVoting::Start()
{
  TRACE_FUNC();

  ///Keeps track of Participants having voted
  m_has_voted.clear();
  assert(m_has_voted.empty());

  BOOST_FOREACH(const Participant * const p,
    GetServer()->GetGroups()->CollectParticipants(false,false,true,false))
  {
    assert(p);
    m_has_voted[p] = false;
    StateVoting * const state = dynamic_cast<const StateVoting*>(this);
    assert(state);
    FindParticipant(p)->SetState(state);
  }
  assert(!CanGoToNextState());
}
//---------------------------------------------------------------------------
