//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "state.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "stopwatch.h"
#include "server.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
ServerStateWaiting::ServerStateWaiting(
  Server * const server)
  : ServerState(server)
{

}
//---------------------------------------------------------------------------
///Check if this state can go to the next state.
bool ServerStateWaiting::CanGoToNextState() const
{
  return true;
}
//---------------------------------------------------------------------------
///Obtain the duration of the state in seconds
int ServerStateWaiting::GetStateDuration() const
{
  return this->GetMaxInt();
}
//---------------------------------------------------------------------------
///Go to the next state. Each state knows its next state.
void ServerStateWaiting::GoToNextState() const
{
  GetServer()->SetState(GetServer()->GetStateGroupDynamics());
}
//---------------------------------------------------------------------------
void ServerStateWaiting::OnTimer()
{
  //if (CanGoToNextState()) GoToNextState();
  //Do NOT go to the next state by a timer, but by uploading Parameters
}
//---------------------------------------------------------------------------
//void ServerStateWaiting::SetParameters(const ParametersWaiting* const parameters)
//{
//  assert(parameters);
//
//  //No parameters yet...
//
//  ResetTimeLeft();
//}
//---------------------------------------------------------------------------
