//---------------------------------------------------------------------------
/*
GTST, Game Theory Server
Copyright (C) 2011 Richel Bilderbeek

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//---------------------------------------------------------------------------
//From http://www.richelbilderbeek.nl/ProjectGtst.htm
//---------------------------------------------------------------------------
#include <cassert>
#include <fstream>
#include <functional>
//#include <iostream>
//---------------------------------------------------------------------------
#include <boost/lexical_cast.hpp>
//---------------------------------------------------------------------------
#include "groupfinished.h"
#include "grouploggedin.h"
#include "groupnotloggedin.h"
#include "groupparticipating.h"
#include "groups.h"
#include "groupassigner.h"
#include "ipaddress.h"
#include "logfile.h"
#include "parameters.h"
#include "parametersassignpayoff.h"
#include "parameterschat.h"
#include "parameterschooseaction.h"
#include "parametersfinished.h"
#include "parametersgroupdynamics.h"
#include "parametersviewresultsall.h"
#include "parametersviewresultsgroup.h"
#include "parametersviewresultsvoting.h"
#include "parametersvoting.h"
#include "participant.h"
#include "repeatassigner.h"
#include "state.h"
#include "stopwatch.h"
#include "test.h"
#include "server.h"
#include "serverstate.h"
#include "serverstateassignpayoff.h"
#include "serverstatechat.h"
#include "serverstatechooseaction.h"
#include "serverstatefinished.h"
#include "serverstategroupdynamics.h"
#include "serverstateviewresultsall.h"
#include "serverstateviewresultsgroup.h"
#include "serverstateviewresultsvoting.h"
#include "serverstatevoting.h"
#include "serverstatewaiting.h"
//---------------------------------------------------------------------------
void Test::TestParticipant()
{
  //Create a GroupAssigner
  const int expected_group = 1 + (std::rand() % 256);
  boost::shared_ptr<GroupAssigner> group_assigner(
    new GroupAssignerPredetermined(expected_group));
  {
    //Test the GroupAssigner
    /*
    for (int i=0; i!=10; ++i)
    {
      const int dummy_id = std::rand();
      assert(group_assigner->Assign(dummy_id) == expected_group
        && "Assume GroupAssignerPredetermined always produces the same integer");
    }
    */
  }

  const char chat_tag = '!' + (std::rand() % 9);

  boost::shared_ptr<Participant> p(
    new Participant(
      chat_tag,
      group_assigner));
  {
    //assert(!p->CanGetGroup());
    assert(!p->CanGetId());
    assert(p->GetActions().empty());
    assert(p->GetVotes().empty());
    assert(!p->CanGetIpAddress());
  }
  //Assign an ID
  {
    const int id = 1 + (std::rand() % 256);
    p->AssignId(id);
    assert(p->CanGetId());
    assert(p->GetId() == id);
  }
  //Assign an IP address
  {
    boost::scoped_ptr<SafeIpAddress> ip_address(
      new SafeIpAddress("123.123.123.123"));
    p->SetIpAddress(ip_address.get());
    assert(p->CanGetIpAddress());
    assert(p->GetIpAddress()->Get()  == ip_address.get()->Get());
  }
  //Assign a group
  {
    //p->AssignGroup();
    //assert(p->CanGetGroup());
    //assert(p->GetGroup() == expected_group);
  }
  //Chat #1
  {
    const std::string chat_message
      = "chat"
      + boost::lexical_cast<std::string>(std::rand());
    assert(p->GetChatLog().empty());
    //std::clog << "p has not yet chatted, not even close\n";
    //assert(!p->HasChatted());
    p->StartChat();
    assert(!p->GetChatLog().empty());
    assert(p->GetChatLog().back().empty());
    //assert(!p->CanGetLastChat());
    //std::clog << "p has not yet chatted\n";
    //assert(!p->HasChatted());
    p->AppendChat(chat_message);
    //assert(p->CanGetLastChat());
    //std::clog << "p has chatted\n";
    assert(!p->GetChatLog().empty());
    assert(!p->GetChatLog().back().empty());
    //assert(p->HasChatted());
    //std::clog << "p should not have an empty chat log\n";
    //assert(!p->GetLastChat().empty());
    //std::clog << "p should not have a chat log with one message\n";
    assert(p->GetChatLog().back().size() == 1);
    //std::clog << "p should not have a chat log with the one message chatted\n";
    assert(p->GetChatLog().back()[0] == chat_message);
  }
  //Voting #1
  {
    const int vote = std::rand();
    //assert(!p->CanGetLastVote());
    //std::clog << "p has not yet voted, not even close\n";
    //assert(p->HasVoted());
    //p->StartVoting();
    //assert(!p->CanGetLastVote());
    //assert(!p->HasVoted());
    assert(p->GetVotes().empty());
    p->Vote(vote);
    assert(!p->GetVotes().empty());
    //assert(p->CanGetLastVote());
    //assert(p->HasVoted());
    //assert(p->GetLastVote() == vote);
  }
  //Choose action #1
  /*
  {
    const int action = std::rand();
    //assert(!p->CanGetLastAction());
    //assert(p->HasChosenAction());
    //p->StartChooseAction();
    //assert(!p->CanGetLastAction());
    //assert(!p->HasChosenAction());
    assert(p->GetActions().empty());
    p->ChooseAction(action);
    assert(!p->GetActions().empty());
    //assert(p->CanGetLastAction());
    //assert(p->HasChosenAction());
    //assert(p->GetLastChosenAction() == action);
  }
  */
  //Voting #2
  {
    const int vote = std::rand();
    //assert(p->CanGetLastVote());
    //assert(p->HasVoted());
    //p->StartVoting();
    //assert(p->CanGetLastVote());
    //assert(!p->HasVoted());
    p->Vote(vote);
    assert(p->GetVotes().size() == 2);
    //assert(p->CanGetLastVote());
    //assert(p->HasVoted());
    //assert(p->GetLastVote() == vote);
  }
  //Choose action #2
  /*
  {
    const int action = std::rand();
    //assert(p->CanGetLastAction());
    //assert(p->HasChosenAction());
    //p->StartChooseAction();
    //assert(p->CanGetLastAction());
    //assert(!p->HasChosenAction());
    p->ChooseAction(action);
    assert(p->GetActions().size() == 2);
    //assert(p->CanGetLastAction());
    //assert(p->HasChosenAction());
    //assert(p->GetLastChosenAction() == action);
  }
  */
  //Chat #2
  {
    const std::string chat_message
      = "chat"
      + boost::lexical_cast<std::string>(std::rand());
    //std::clog << "p has a chat log\n";
    //assert(p->CanGetLastChat());
    //std::clog << "p has chatted in the previous round\n";
    //assert(p->HasChatted());
    assert(p->GetChatLog().size() == 1);
    p->StartChat();
    assert(p->GetChatLog().size() == 2);
    assert(p->GetChatLog().back().empty());
    //assert(!p->CanGetLastChat());
    //std::clog << "p has not yet chatted in this round\n";
    //assert(!p->HasChatted());
    p->AppendChat(chat_message);
    assert(!p->GetChatLog().back().empty());
    //assert(p->CanGetLastChat());
    //std::clog << "p has chatted in this round\n";
    //assert(p->HasChatted());
    //assert(!p->GetLastChat().empty());
    //assert(p->GetLastChat().size() == 1);
    assert(p->GetChatLog().back()[0] == chat_message);
  }
  ///Check the default Participant creation
  {
    boost::shared_ptr<Participant> p1
      = Parameters::CreateDefaultParticipant();
    boost::shared_ptr<Participant> p2
      = Parameters::CreateDefaultParticipant();
    assert(p1->GetChatTag() != p2->GetChatTag());

  }
}
//---------------------------------------------------------------------------

