#!/bin/sh
#zip packs all the files to port into a single .zip file,
#minicking the same folder structure
#Folder structure
# *
#  * Classes
#    * CppAbout
#    * CppCopy_if
#    * CppCounter
#    * CppFuzzy_equal_to
#    * CppIpAddress
#    * CppStopwatch
#    * CppTrace
#    * CppWtAboutDialog
#    * CppWtAutoConfig
#  * Projects
#    * ProjectGtst
echo "Creating a sloccount file"
sloccount ../ProjectGtst > sloccount.txt

echo "Creating documentation"
doxygen doxygen_config.txt

echo "Removing user information"
rm ProjectGtst.pro.user

echo "Removing some temp files from other tools"
rm copy.txt
rm tmp.txt

echo "Mimicking file structure"
mkdir temp_zip
mkdir temp_zip/Classes
mkdir temp_zip/Classes/CppAbout
mkdir temp_zip/Classes/CppCopy_if
mkdir temp_zip/Classes/CppCounter
mkdir temp_zip/Classes/CppFuzzy_equal_to
mkdir temp_zip/Classes/CppIpAddress
mkdir temp_zip/Classes/CppStopwatch
mkdir temp_zip/Classes/CppTrace
mkdir temp_zip/Classes/CppWtAboutDialog
mkdir temp_zip/Classes/CppWtAutoConfig
mkdir temp_zip/Projects
mkdir temp_zip/Projects/ProjectGtst

echo "Copying files"
cp ../../Classes/CppAbout/*.* temp_zip/Classes/CppAbout
cp ../../Classes/CppCopy_if/*.* temp_zip/Classes/CppCopy_if
cp ../../Classes/CppCounter/*.* temp_zip/Classes/CppCounter
cp ../../Classes/CppFuzzy_equal_to/*.* temp_zip/Classes/CppFuzzy_equal_to
cp ../../Classes/CppIpAddress/*.* temp_zip/Classes/CppIpAddress
cp ../../Classes/CppStopwatch/*.* temp_zip/Classes/CppStopwatch
cp ../../Classes/CppTrace/*.* temp_zip/Classes/CppTrace
cp ../../Classes/CppWtAboutDialog/*.* temp_zip/Classes/CppWtAboutDialog
cp ../../Classes/CppWtAutoConfig/*.* temp_zip/Classes/CppWtAutoConfig
cp ../../Projects/ProjectGtst/*.* temp_zip/Projects/ProjectGtst

echo "Remove previous zip"
rm ProjectGtstSource_0_45.zip

echo "Compressing files"
cd temp_zip
zip -r ProjectGtstSource_0_45 Classes
zip -r ProjectGtstSource_0_45 Projects
cd ..
cp temp_zip/ProjectGtstSource_0_45.zip ProjectGtstSource_0_45.zip

echo "Cleaning up"
rm temp_zip/Classes/CppAbout/*.*
rm temp_zip/Classes/CppCopy_if/*.*
rm temp_zip/Classes/CppCounter/*.*
rm temp_zip/Classes/CppFuzzy_equal_to/*.*
rm temp_zip/Classes/CppIpAddress/*.*
rm temp_zip/Classes/CppStopwatch/*.*
rm temp_zip/Classes/CppTrace/*.*
rm temp_zip/Classes/CppWtAboutDialog/*.*
rm temp_zip/Classes/CppWtAutoConfig/*.*
rmdir temp_zip/Classes/CppAbout
rmdir temp_zip/Classes/CppCopy_if
rmdir temp_zip/Classes/CppCounter
rmdir temp_zip/Classes/CppFuzzy_equal_to
rmdir temp_zip/Classes/CppIpAddress
rmdir temp_zip/Classes/CppStopwatch
rmdir temp_zip/Classes/CppTrace
rmdir temp_zip/Classes/CppWtAboutDialog
rmdir temp_zip/Classes/CppWtAutoConfig
rmdir temp_zip/Classes

rm temp_zip/Projects/ProjectGtst/*.*
rmdir temp_zip/Projects/ProjectGtst
rmdir temp_zip/Projects

rm temp_zip/*.*
rmdir temp_zip
echo "Done"
