require 'java'

import "eu.webtoolkit.jwt.WApplication"
import "eu.webtoolkit.jwt.WBreak"
import "eu.webtoolkit.jwt.WText"
import "eu.webtoolkit.jwt.auth.GoogleService"
import "eu.webtoolkit.jwt.auth.FacebookService"

import "eu.webtoolkit.jwt.auth.AuthService"

#global variables for facebook and google login
#they are inited only once
$authservice=AuthService.new()
$fblogin=FacebookService.new($authservice)
$glogin=GoogleService.new($authservice)

class OALogin < WApplication

	def initialize(env)
		super(env)
		setTitle("OAuth Login")
		#debug to stdout, both are true
		puts
		puts FacebookService::configured
		puts GoogleService::configured
		puts
		
		fbt=WText.new "Log in with FB",getRoot
		WBreak.new getRoot
		
		
		fbprocess=$fblogin.createProcess($fblogin.getAuthenticationScope)
		fbprocess.connectStartAuthenticate fbt.clicked
		fbprocess.authenticated.addListener(self) {|o|
			#here I get the email address and ID correctly
			WText.new "Welcome from FaceBook "+o.getEmail+" "+o.getId,getRoot
		}
		                
		gt=WText.new "Log in with Google",getRoot
		WBreak.new getRoot                
		
		gbprocess=$glogin.createProcess($glogin.getAuthenticationScope)
		gbprocess.connectStartAuthenticate gt.clicked
		gbprocess.authenticated.addListener(self) {|o|
			#this event triggers, but the email address and the ID are empty
			WText.new "Welcome from Google"+o.getEmail+" "+o.getId,getRoot
		}
	end
end


