/*
 * Presentation.h
 *
 *  Created on: Apr 13, 2010
 *      Author: gci
 */

#ifndef PRESENTATION_H_
#define PRESENTATION_H_

#include <Wt/Dbo/Types>
#include "CompositeKey.h"

namespace dbo = Wt::Dbo;

namespace Domain
{

class Map;

class Presentation
{

protected:

	CompositeKey pKey_;
	int idMap_;
	int zOrder_;
	int transparency_;
	std::string aliasName_;
	dbo::ptr<Map> map_;

public:

	Presentation();

	virtual ~Presentation();

	dbo::ptr<Map> getMap() const;

	void setMap(dbo::ptr<Map> map);

    std::string getAliasName() const
    {
        return aliasName_;
    }

    CompositeKey getPKey() const
    {
        return pKey_;
    }

    int getOrder() const
    {
        return zOrder_;
    }

    int getTransparency() const
    {
        return transparency_;
    }

    int getIdMap() const
    {
        return idMap_;
    }

    void setAliasName(std::string aliasName)
    {
        this->aliasName_ = aliasName;
    }

    void setId(CompositeKey pkey)
    {
        this->pKey_ = pkey;
    }

    void setIdMap(int idMap)
    {
        this->idMap_ = idMap;
    }

    void setZorder(int zOrder)
    {
        this->zOrder_ = zOrder;
    }

    void setTransparency(int transparency)
    {
        this->transparency_ = transparency;
    }
};

}

#endif /* PRESENTATION_H_ */
