/*
 * RasterPresentation.h
 *
 *  Created on: Apr 13, 2010
 *      Author: gci
 */

#ifndef RASTERPRESENTATION_H_
#define RASTERPRESENTATION_H_

#include "Presentation.h"

namespace Domain
{

class RasterLayer;
class Map;

class RasterPresentation: public Presentation
{
private:

	std::string lut_;
	dbo::ptr<RasterLayer> layer_;

public:

	RasterPresentation();

	virtual ~RasterPresentation();

	dbo::ptr<RasterLayer> getLayer() const;

	void setLayer(dbo::ptr<RasterLayer> layer);

    template <class Action>
    void field(Action& action, CompositeKey& compositeKey, const std::string& name, int size = -1)
    {
      field(action, compositeKey.id_, name);
      field(action, compositeKey.idMandator_, name + "Mandator");
    }

    template<class Action>
	void persist(Action& a)
	{
    	dbo::id(a, pKey_, "id");

		dbo::field(a, idMap_, "idmap");
		dbo::field(a, zOrder_,     "zorder");
		dbo::field(a, transparency_,    "transparency");
		dbo::field(a, lut_,    "lut");
		dbo::field(a, aliasName_, "aliasname");

	    dbo::belongsTo(a, map_, "map");
	    dbo::belongsTo(a, layer_, "layer");
	}
};

}

namespace Wt
{
  namespace Dbo
  {
	  template<>
	  struct dbo_traits<Domain::RasterPresentation>
	  {
		  typedef Domain::CompositeKey IdType;

		  static const char *surrogateIdField()
		  {
			return 0;
		  }

	      static const char *versionField()
	      {
	        return 0;
	      }

	      static IdType invalidId()
	      {
	    	  Domain::CompositeKey key(-1, -1);
	    	  return key;
	      }
	  };
  }
}

DBO_EXTERN_TEMPLATES(Domain::RasterPresentation);

#endif /* RASTERPRESENTATION_H_ */
