/*
 * Copyright (C) 2008 Emweb bvba, Heverlee, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <boost/smart_ptr.hpp>
#include "Receiver.h"
#include <Wt/WServer>
#include <Wt/WIOService>
#include <boost/ref.hpp>

using namespace Wt;
using namespace std;

namespace{

class ReceiverWrapper : WObject{
private:
	boost::scoped_ptr<Receiver> _receiver;

public:
	ReceiverWrapper(WObject* parent, const std::string& host, const std::string& port, boost::asio::io_service& io) :
		WObject(parent), _receiver(new Receiver(host, port, io)){}

//	SEClient* seclient()const{ return _seclient.get(); }

	Receiver::ReceivedSignal& received_message(){return _receiver->received_message(); }

	~ReceiverWrapper(){cout << "Destroyed receiver wrapper" << endl;}
};


class MessageApplication : public WApplication
{
public:
	MessageApplication(const WEnvironment& env/*, boost::asio::io_service& io*/);

private:
	//  WLineEdit *nameEdit_;
	WText *message_;
//	boost::asio::io_service& _io;
	boost::asio::io_service _io;

	void start();
};

/*
 * The env argument contains information about the new session, and
 * the initial request. It must be passed to the WApplication
 * constructor so it is typically also an argument for your custom
 * application constructor.
 */
MessageApplication::MessageApplication(const WEnvironment& env/*, boost::asio::io_service& io*/)
: WApplication(env)/*, _io(io)*/
{
	setTitle("Hello world");                               // application title

	WPushButton *button
	= new WPushButton("Start", root());              // create a button
	button->setMargin(5, Left);                            // add 5 pixels margin

	root()->addWidget(new WBreak());                       // insert a line break

	message_ = new WText(root());                         // empty text

	message_->setText("Messages will arrive here");

	/*
	 * Connect signals with slots
	 *
	 * - simple Wt-way
	 */
	button->clicked().connect(this, &MessageApplication::start);

}

void MessageApplication::start()
{
	ReceiverWrapper* receiver = new ReceiverWrapper(this, "0.0.0.0", "8085", _io);

	receiver->received_message().connect(boost::bind(&WText::setText, message_, _1));

	_io.poll();

//	message_->setText("Message");
}

WApplication *createApplication(const WEnvironment& env/*, boost::asio::io_service& io*/)
{
	return new MessageApplication(env/*, io*/);
}
}

int main(int argc, char **argv)
{
	  try {
	    WServer server(argv[0]);

	    server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);

//	    server.addEntryPoint(Application, boost::bind(createApplication, _1, boost::ref(server.ioService())));
	    server.addEntryPoint(Application, createApplication);

	    if (server.start()) {
	      WServer::waitForShutdown();
	      server.stop();
	    }
	  } catch (WServer::Exception& e) {
	    std::cerr << e.what() << std::endl;
	  } catch (std::exception &e) {
	    std::cerr << "exception: " << e.what() << std::endl;
	  }

}

