/*
 * SEClient.cpp
 *
 *  Created on: Aug 27, 2013
 *      Author: rajeev
 */

#include "Receiver.h"


using namespace boost::asio;
using namespace std;

Receiver::Receiver(const string& host, const string& port, boost::asio::io_service& io) : _connection(io){
	ip::tcp::resolver resolver(io);
	ip::tcp::resolver::query query(host, port);
	endpoint_iterator = resolver.resolve(query);

	async_connect(_connection.socket(), endpoint_iterator, boost::bind(&Receiver::handle_connect, this, _1));
}

Receiver::~Receiver() { }

Receiver::ReceivedSignal& Receiver::received_message(){
	return _received_result;
}

void Receiver::handle_connect(const boost::system::error_code& error){
	_connection.async_read<std::string>(boost::bind(&Receiver::handle_read, this, _1, _2));
}

void Receiver::handle_read(const string& message, const boost::system::error_code& error){
	cout << "Message received" << endl;
	_received_result(message);
	_connection.async_read<std::string>(boost::bind(&Receiver::handle_read, this, _1, _2));
}

