/*
 * SEClient.h
 *
 *  Created on: Aug 27, 2013
 *      Author: rajeev
 */

#ifndef SECLIENT_H_
#define SECLIENT_H_

#include <boost/asio.hpp>
#include <string>
#include "connection.h"

class Receiver {
public:
	typedef boost::signals2::signal<void (const std::string& message)> ReceivedSignal;
private:
//	boost::asio::io_service io;
	boost::asio::ip::tcp::resolver::iterator endpoint_iterator;
	connection _connection;
	ReceivedSignal _received_result;

public:
	Receiver(const std::string& host, const std::string& port, boost::asio::io_service& io);
	ReceivedSignal& received_message();
	virtual ~Receiver();

private:
	void handle_connect(const boost::system::error_code& error);
	void handle_read(const std::string& message, const boost::system::error_code& error);
};


#endif /* SECLIENT_H_ */
