/*
 * SEServer.h
 *
 *  Created on: Aug 24, 2013
 *      Author: rajeev
 */

#ifndef SESERVER_H_
#define SENDER_H_

#include <iostream>
#include <sstream>
#include <string>
#include <boost/asio.hpp>
#include <boost/date_time/posix_time/posix_time_types.hpp>
#include <boost/signals2.hpp>
#include "connection.h"

class Sender {
public:
	Sender(boost::asio::io_service& io_service, const boost::posix_time::milliseconds& sample_time,
			unsigned short port = 8080);


	typedef boost::signals2::signal<void(const std::string&)> MessageSignal;
private:
	boost::asio::deadline_timer           _timer;
	const boost::posix_time::milliseconds _sample_time;
	boost::asio::ip::tcp::acceptor        _acceptor;
	MessageSignal                         _message;

	void handle_accept(const boost::system::error_code& e, connection_ptr conn);
	void generate_message(const boost::system::error_code& error);
	int count;

public:
	void handle_write(const boost::system::error_code& error, connection_ptr conn);

};


#endif /* SENDER_H_ */
