/*
 * connection.C
 *
 *  Created on: May 6, 2013
 *      Author: Rajeev Gajbhiye
 */

#include "connection.h"
#include <iostream>

using namespace std;

connection::connection(boost::asio::io_service& io_service) : _socket(io_service) { }

boost::asio::ip::tcp::socket& connection::socket() { return _socket; }

boost::signals2::signal<void()>& connection::destroyed(){ return _destroyed; }

boost::signals2::signal<void()>& connection::closed(){ return _closed; }

connection::~connection(){ _destroyed(); cout << "Destroying the connection" << endl;}

void connection::close(){ _socket.close(); _closed();}

//void connection::shutdown(boost::asio::ip::tcp::socket::shutdown_type shutdown_type){ _socket.shutdown(shutdown_type); }

bool connection::interpret_header(const boost::system::error_code& e){
	if (e) {
		//			boost::get<0>(handler)(e);
		std::cerr << e.message() << std::endl;
		return false;
	}
	else {
		std::istringstream is(std::string(_inbound_header, header_length));
		std::size_t inbound_data_size = 0;
		if (!(is >> std::hex >> inbound_data_size))
		{
			//				boost::system::error_code error(boost::asio::error::invalid_argument);
			//				boost::get<0>(handler)(error);
			std::cerr << "Invalid argument" << std::endl;
			return false;
		}

		_inbound_data.resize(inbound_data_size);
	}
	return true;
}
