/*
 * SEServer.cpp
 *
 *  Created on: Aug 24, 2013
 *      Author: rajeev
 */

#include "Sender.h"
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/string.hpp>
#include <boost/bind.hpp>
#include <boost/random.hpp>
#include <boost/random/normal_distribution.hpp>

using namespace boost::asio;
using namespace std;

namespace{
struct MessageHandler{
	typedef void result_type;
	void handle(Sender* _sender, connection_ptr conn, const string& message){
		conn->async_write(message, boost::bind(&Sender::handle_write, _sender, boost::asio::placeholders::error, conn));
	}
};

}

void Sender::handle_accept(const boost::system::error_code& e, connection_ptr conn){
	if (!e){
		/*
		boost::signals2::connection connection = _message.connect([conn, this](const string& message){
			conn->async_write(message, boost::bind(&sender::handle_write, this, boost::asio::placeholders::error, conn));
		}
			);
		 */
		boost::signals2::connection connection = _message.connect(boost::bind(&MessageHandler::handle, MessageHandler(), this, conn, _1));
		//		conn->destroyed().connect([connection](){connection.disconnect(); cout << "Slot disconnected" << endl;});
		//		conn->closed().connect([connection](){connection.disconnect(); cout << "Slot disconnected" << endl;});

		conn->destroyed().connect(boost::bind(&boost::signals2::connection::disconnect, connection));
		conn->closed().connect(boost::bind(&boost::signals2::connection::disconnect, connection));
	}
	else {
		cerr << e.message() << endl;
	}

	connection_ptr new_conn(new connection(_acceptor.get_io_service()));
	_acceptor.async_accept(new_conn->socket(), boost::bind(&Sender::handle_accept, this, boost::asio::placeholders::error, new_conn));
}


Sender::Sender(boost::asio::io_service& io_service, const boost::posix_time::milliseconds& sample_time,
		unsigned short port) : _timer(io_service), _sample_time(sample_time),
				_acceptor(io_service, ip::tcp::endpoint(ip::tcp::v4(), port)), count(0){
	_timer.expires_from_now(_sample_time);
	_timer.async_wait( boost::bind(&Sender::generate_message, this, boost::asio::placeholders::error));

	connection_ptr new_conn(new connection(_acceptor.get_io_service()));
	_acceptor.async_accept(new_conn->socket(), boost::bind(&Sender::handle_accept, this, boost::asio::placeholders::error, new_conn));
}

void Sender::generate_message(const boost::system::error_code& error) {
	if (!error) {
		cout << "Sending message" << endl;



		_message("Mesage " + boost::lexical_cast<string>(++count));

		_timer.expires_from_now(_sample_time);
		_timer.async_wait( boost::bind(&Sender::generate_message, this,
				boost::asio::placeholders::error));
	}
}

void Sender::handle_write(const boost::system::error_code& error, connection_ptr conn){
	cout << "Message sent " << error << endl;
	if (error){
		cout << "Closing connection" << endl;
		conn->close();
	}
}


