/*--------------------------------------------------------------------------------

*/

#include <Wt/WAnchor>
#include <Wt/WText>
#include <Wt/WStackedWidget>
#include <Wt/WVBoxLayout>
#include <Wt/WHBoxLayout>
#include <Wt/WApplication>
#include <Wt/Auth/AuthWidget>

#include "HangmanGame.h"


  HangmanGame::HangmanGame(Wt::WContainerWidget *parent) :
    WContainerWidget(parent)
  {

    // build the authorization widget - it is a little heavy
    //
      session_.login().changed().connect(this, &HangmanGame::onAuthEvent);

      Wt::Auth::AuthModel *authModel = new Wt::Auth::AuthModel(Session::auth(), session_.users(), this);
      authModel->addPasswordAuth(&Session::passwordAuth());
      authModel->addOAuth(Session::oAuth());

      Wt::Auth::AuthWidget *authWidget = new Wt::Auth::AuthWidget(session_.login());
      authWidget->setModel(authModel);
      authWidget->setRegistrationEnabled(true);

      Wt::WText *title = new Wt::WText("<h1>A Witty game: Hangman</h1>");
      addWidget(title);

      addWidget(authWidget);

      // game stuff deleted ...

      authWidget->processEnvironment();
  }

  void HangmanGame::onAuthEvent(){
    std::cout << "on auth event" << std::endl;
  }

void HangmanGame::handlePathChange(const std::string &internalPath){

  std::cout << "handlePathChange" << std::endl;

};

