/*--------------------------------------------------------------------------------

  build:
  g++ -std=c++11 -lcrypt -lwthttp -lwt -lwtdbo -lwtdbosqlite3 -lboost_signals-mt -lboost_system-mt -o hangman hangman.C Session.C HangmanGame.C User.C

  run:
    ./hangman --docroot . --http-address 127.0.0.1 --http-port 9090
    then visit 127.0.0.1:9090

*/

#include <Wt/WApplication>
#include <Wt/WServer>

#include "HangmanGame.h"
#include "Session.h"


Wt::WApplication *createApplication(const Wt::WEnvironment& env){

  Wt::WApplication *app = new Wt::WApplication(env);
  
  app->setTitle("Hangman");

  app->messageResourceBundle().use(app->appRoot() + "strings");
  app->messageResourceBundle().use(app->appRoot() + "templates");

  app->useStyleSheet("css/hangman.css");

  new HangmanGame(app->root());

  return app;
}

int main(int argc, char **argv){
  try {
    Wt::WServer server(argv[0]);

    server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);
    server.addEntryPoint(Wt::Application, createApplication);

    Session::configureAuth();

    if (server.start()) {
      Wt::WServer::waitForShutdown();
      server.stop();
    }
  } catch (Wt::WServer::Exception& e) {
    std::cerr << e.what() << std::endl;
  } catch (std::exception &e) {
    std::cerr << "exception: " << e.what() << std::endl;
  }
}
