#include <Wt/Dbo/Query> //Query
#include <Wt/Dbo/ptr> //ptr
#include <Wt/Dbo/collection> //collection

#include "SBlogPreCompile.h" //collection

#include "ArticleListWidget.h" //ArticleListWidget
#include "ArticleDigestWidget.h" //ArticleDigestWidget
#include "SbDbItem.h" //SbDbItem

/*!
 * \brief StoreListWidget::StoreListWidget Constructor.
 * \param Ssn2Use The wt dbo session to use.
 */
ArticleListWidget::ArticleListWidget(Dbo::Session *Ssn2Use):session(Ssn2Use)
{
    qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.

    CurntPage=1; //The current page.
    ItmsPerPage=5; //5 items per page.
    UsrId=0; //Default,no valid user id.
    RstrctdAccs=false; //Not restrict info access.

    dgstLstWdgt=new WContainerWidget; //Create the digest container.
    addWidget (dgstLstWdgt); //Add the digest container.

    PgNav=new WContainerWidget(); //Create the page navigation container.
    addWidget(PgNav); //Add the page navigation container.

    LstPgBtn=new WPushButton(WString::tr("Previous page")); //The button of previous page.
    LstPgBtn->clicked().connect(this,&ArticleListWidget::TurnLastPage); //Clicked , then turn to the previous page.
    PgNav->addWidget(LstPgBtn); //Add the button.


    CrtPgLbl=new WLabel(WString::tr("1")); //The label of current page.
    PgNav->addWidget(CrtPgLbl); //Add current page label.

    WLabel * SlshLbl=new WLabel(WString::tr("/")); //The slash.
    PgNav->addWidget(SlshLbl); //Add the slash.


    TtlPgLbl=new WLabel(); //The label of total pages.
    PgNav->addWidget(TtlPgLbl); //Add the total page label.


    NxtPgBtn=new WPushButton(WString::tr("Next page")); //The next page button.
    NxtPgBtn->clicked().connect(this,&ArticleListWidget::TurnNextPage); //Clicked , then turn to next page.
    PgNav->addWidget(NxtPgBtn); //Add the next page button.

    PgSpnBx=new WLineEdit; //Create the page number spin box.
//    PgSpnBx->setMinimum(1); //The minimum page number.
//    PgSpnBx->setValue(1); //Currently 1st page.
    PgNav->addWidget(PgSpnBx); //Show the spin box.

    WPushButton * JmpBtn=new WPushButton(WString::tr("Jump to page")); //The jump to page button.
    JmpBtn->clicked().connect(this,&ArticleListWidget::Jump2Page); //Button clicked,then jump to the page.
    PgNav->addWidget(JmpBtn); //Show the jump button.


    WPushButton * AdStrBtn=new WPushButton(WString::tr("Add Store")); //Create the add store button.
    PgNav->addWidget(AdStrBtn); //Add the button.

    ListArticles(); //列出Article digests on this page。
} //ArticleListWidget::ArticleListWidget(Dbo::Session *Ssn2Use):session(Ssn2Use)

/*!
 * \brief FinanceFlowListWidget::ListFlow 列出资金流水。
 */
void ArticleListWidget::ListArticles()
{
    qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.

    WSignalMapper<WPushButton *> * ManageAnchorSignalMapper=new WSignalMapper<WPushButton *>(this); //按钮的信号映射器。

    ManageAnchorSignalMapper->mapped().connect(this,&ArticleListWidget::ModifyStore); //当“修改信息”链接被点击时，触发管理函数。


    WSignalMapper<WPushButton *> * DltSignalMapper=new WSignalMapper<WPushButton *>(this); //Delete user按钮的信号映射器。

    dbo::Transaction transaction(*session); //创建事务。

    //列出流水列表：
    typedef dbo::collection<dbo::ptr<SbDbItem> > Flows; //定义复合类型，文章列表。

    Flows flows=session->find<SbDbItem>(); //查询文章列表。


    int TtlPgAmt=1; //Total page amount.


    if (RstrctdAccs) //This user can only access the store managed by him/her.
    {
        qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.
        TtlPgAmt=1; //Page amount is 1.


        ListOnlyStoreByUser(); //List the only store managed by this user.
        qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.
    } //if (RstrctdAccs) //This user can only access the store managed by him/her.
    else //This is the root .List all stores by page.
    {
        TtlPgAmt=ceil((double)(flows.size())/(double)(ItmsPerPage)); //Calculate the total page amount.
        qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.


        TtlPgLbl->setText(WString::tr("{1}").arg(TtlPgAmt)); //Show the total page amount.
        qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.

        CrtPgLbl->setText(WString::tr("{1}").arg(CurntPage)); //Show the current page.

        if (CurntPage<=1) //It is the 1st page.
        {
            LstPgBtn->setEnabled(false); //Disable this button.
        } //if (CurntPage<=1) //It is the 1st page.
        else //It is not the 1st page.
        {
            LstPgBtn->setEnabled(true); //Enable this button.
        } //else //It is not the 1st page.

        if (CurntPage>=TtlPgAmt) //It is the last page.
        {
            NxtPgBtn->setEnabled(false); //Disable this button.
        } //if (CurntPage>=TtlPgAmt) //It is the last page.
        else //It is not the last page.
        {
            NxtPgBtn->setEnabled(true); //Enable this button.
        } //else //It is not the last page.

        Flows::const_iterator i=flows.begin(); //The iterator of the flows.

        //Jump over the previous pages:
        int JmpCtr=0; //The jump items counter.
        int JmpTtl=(CurntPage-1)*ItmsPerPage; //The total amount of items to jump over.
        for (JmpCtr=1;JmpCtr<=JmpTtl;JmpCtr++) //Jump the items one by one.
        {
            i++; //Move to the next item.
        } //for (JmpCtr=1;JmpCtr<=JmpTtl;JmpCtr++) //Jump the items one by one.


        int UsrCtr=0; //用户计数器。
        for (;i!=flows.end();++i) //一个个地列出。
        {
            ArticleDigestWidget * crtAtcDgst=new ArticleDigestWidget; //Create a digest widget.
            crtAtcDgst->setArticleId ( (*i).id() ); //设置文章编号。
            dgstLstWdgt->addWidget (crtAtcDgst); //Add the article digest.


            WPushButton * EdtBtn=new WPushButton(WString::tr("Edit")); //创建编辑按钮。

            AprBtnIdMap[EdtBtn]=(*i).id(); //记录映射关系。
            ManageAnchorSignalMapper->mapConnect(EdtBtn->clicked(),EdtBtn); //将按钮映射到映射器。


            WPushButton * DltBtn=new WPushButton(WString::tr("Delete Store")); //删除店铺按钮。

            AprBtnIdMap[DltBtn]=(*i).id(); //记录映射关系。

            OprBtnRowMap[DltBtn]=UsrCtr+1; //记录按钮与表格行号之间的映射关系。
            DltSignalMapper->mapConnect(DltBtn->clicked(),DltBtn); //将按钮映射到映射器。

            UsrCtr++; //计数。

            if (UsrCtr>=ItmsPerPage) //We have 1 page now.
            {
                break; //break.
            } //if (UsrCtr>=ItmsPerPage) //We have 1 page now.
        } //for (Users::const_iterator i=users.begin();i!=users.end();++i)

    } //else //This is the root .

    return;
} //void FinanceFlowListWidget::ListFlow() //!<列出资金流水。

/*!
 * \brief FinanceFlowListWidget::refresh 刷新。
 */
void ArticleListWidget::refresh()
{
    ListArticles(); //列出资金流水。

    return;
} //void FinanceFlowListWidget::refresh() //!<刷新。

/*!
 * \brief FinanceFlowListWidget::TurnNextPage Clicked , then turn to next page.
 */
void ArticleListWidget::TurnNextPage()
{
    CurntPage++; //Change the current page.

    ListArticles(); //List the flows.

    return;
} //void FinanceFlowListWidget::TurnNextPage() //!<Clicked , then turn to next page.

/*!
 * \brief FinanceFlowListWidget::TurnLastPage Clicked , then turn to the previous page.
 */
void ArticleListWidget::TurnLastPage()
{
    CurntPage--; //Change the current page.

    ListArticles(); //List the flows.

    return;
} //void FinanceFlowListWidget::TurnLastPage() //!<Clicked , then turn to the previous page.

/*!
 * \brief FinanceFlowListWidget::Jump2Page Button clicked,then jump to the page.
 */
void ArticleListWidget::Jump2Page()
{
    CurntPage= QString::fromUtf8((PgSpnBx->text()).toUTF8().c_str()).toInt();

    ListArticles(); //List the flows.

    return;
} //void FinanceFlowListWidget::Jump2Page() //!<Button clicked,then jump to the page.

/*!
 * \brief StoreListWidget::EditStore  Edit this store.
 * \param ImgPtrid The store id.
 */
void ArticleListWidget::EditStore(int ImgPtrid)
{
    ShouldEditStore.emit(ImgPtrid); //Emit the signal.

    return;
} //void StoreListWidget::EditStore(int ImgPtrid) //!<Edit this store.

/*!
 * @brief 当“修改信息”链接被点击时，触发管理函数。
 */
void ArticleListWidget::ModifyStore(WPushButton * EdtBtn)
{
    int UsrId=AprBtnIdMap[EdtBtn]; //获取店铺的编号。

    EditStore(UsrId); //编辑此店铺。


    return;
} //void StoreListWidget::ModifyStore(WPushButton * EdtBtn) //!<当“修改信息”链接被点击时，触发管理函数。

/*!
 * \brief StoreManageTabWidget::SetRestrictedInfoAccess Set the info access previlege.
 * \param WhetherRestricttrue Whether we should restrict the access of this user in the current session.
 * \param RstctUsrId The user id bound to this session.
 */
void ArticleListWidget::SetRestrictedInfoAccess(bool WhetherRestricttrue,int RstctUsrId)
{
    qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("Whether to restrict:") << WhetherRestricttrue; //Debug.

    RstrctdAccs=WhetherRestricttrue; //Remember.
    UsrId=RstctUsrId; //Remember.

    ListArticles(); //List the stores.

    return;
} //void StoreManageTabWidget::SetRestrictedInfoAccess(bool WhetherRestricttrue,int RstctUsrId) //!<Set the info access previlege.

/*!
 * \brief StoreManageTabWidget::ListOnlyStoreByUser List the only store managed by this user.
 * \param UsrId2Lst The user's id.
 */
void ArticleListWidget::ListOnlyStoreByUser()
{
    PgNav->hide(); //Hide the page navigation bar.

    WSignalMapper<WPushButton *> * ManageAnchorSignalMapper=new WSignalMapper<WPushButton *>(this); //按钮的信号映射器。

    ManageAnchorSignalMapper->mapped().connect(this,&ArticleListWidget::ModifyStore); //当“修改信息”链接被点击时，触发管理函数。



    dbo::Transaction transaction(*session); //创建事务。

    CrtPgLbl->setText(WString::tr("{1}").arg(CurntPage)); //Show the current page.

    if (CurntPage<=1) //It is the 1st page.
    {
        LstPgBtn->setEnabled(false); //Disable this button.
    } //if (CurntPage<=1) //It is the 1st page.
    else //It is not the 1st page.
    {
        LstPgBtn->setEnabled(true); //Enable this button.
    } //else //It is not the 1st page.

    WPushButton * EdtBtn=new WPushButton(WString::tr("Edit")); //创建编辑按钮。

    ManageAnchorSignalMapper->mapConnect(EdtBtn->clicked(),EdtBtn); //将按钮映射到映射器。

    return;
} //void StoreManageTabWidget::ListOnlyStoreByUser(int UsrId2Lst) //!<List the only store managed by this user.

/*!
 * \brief StoreListWidget::updatePageNavBar 更新翻页导航条的各个元素。
 */
void ArticleListWidget::updatePageNavBar()
{
    dbo::Transaction transaction(*session); //创建事务。

    //列出流水列表：
    typedef dbo::collection<dbo::ptr<SbDbItem> > Flows;
    Flows flows=session->find<SbDbItem>(); //查询Store info。

    int TtlPgAmt=1; //Total page amount.

    TtlPgAmt=ceil((double)(flows.size())/(double)(ItmsPerPage)); //Calculate the total page amount.
    qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.


    TtlPgLbl->setText(WString::tr("{1}").arg(TtlPgAmt)); //Show the total page amount.
    //        PgSpnBx->setMaximum(TtlPgAmt); //Set the maximum page number to jump.
    qDebug() << __FILE__ << __LINE__ << __func__ << QObject::tr("constructor"); //Debug.


    CurntPage=qMin(CurntPage,TtlPgAmt); //当前页号不超过总页数。

    CrtPgLbl->setText(WString::tr("{1}").arg(CurntPage)); //Show the current page.

    if (CurntPage<=1) //It is the 1st page.
    {
        LstPgBtn->setEnabled(false); //Disable this button.
    } //if (CurntPage<=1) //It is the 1st page.
    else //It is not the 1st page.
    {
        LstPgBtn->setEnabled(true); //Enable this button.
    } //else //It is not the 1st page.

    if (CurntPage>=TtlPgAmt) //It is the last page.
    {
        NxtPgBtn->setEnabled(false); //Disable this button.
    } //if (CurntPage>=TtlPgAmt) //It is the last page.
    else //It is not the last page.
    {
        NxtPgBtn->setEnabled(true); //Enable this button.
    } //else //It is not the last page.

    return;
} //void StoreListWidget::updatePageNavBar() //!<更新翻页导航条的各个元素。
