#ifndef ARTICLE_LISTWIDGET_H
#define ARTICLE_LISTWIDGET_H

/*!
 * \brief The StoreListWidget class Blog list widget.
 */
class ArticleListWidget : public WContainerWidget
{
public:
    void SetRestrictedInfoAccess(bool WhetherRestricttrue,int RstctUsrId); //!<Set the info access previlege.
    void refresh(); //!<刷新。
    ArticleListWidget(dbo::Session * Ssn2Use); //!<Constructor.
    Signal  <int>  ShouldEditStore; //!<Should edit the store of this id.

private:
    WContainerWidget * dgstLstWdgt; //!<The widget containing the digests.
    void updatePageNavBar(); //!<更新翻页导航条的各个元素。
    std::map<WPushButton*,int> OprBtnRowMap; //!<Delete User按钮与表格行号之间的映射。
    WContainerWidget * PgNav; //!<The page navigation container.
    void ListOnlyStoreByUser(); //!<List the only store managed by this user.
    bool RstrctdAccs; //!<Whether to restrict the info access of this user.
    std::map<WPushButton*,int> AprBtnIdMap; //!<修改密码按钮与用户编号之间的映射。
    void ModifyStore(WPushButton * EdtBtn); //!<当“修改信息”链接被点击时，触发管理函数。
    void EditStore(int ImgPtrid); //!<Edit this store.
    int UsrId; //!<The user id.
    void Jump2Page(); //!<Button clicked,then jump to the page.
    WLineEdit * PgSpnBx; //!<The spin box of the page number to jump to.
    WPushButton * NxtPgBtn; //!<The button to turn to next page.
    WPushButton * LstPgBtn; //!<The button to turn to previous page.
    void TurnLastPage(); //!<Clicked , then turn to the previous page.
    WLabel * CrtPgLbl; //!<The label of the current page.
    void TurnNextPage(); //!<Clicked , then turn to next page.
    int CurntPage; //!<The current page.
    int ItmsPerPage; //!<50 items per page.
    WLabel * TtlPgLbl; //!<The label which shows the total page amount.
    dbo::Session * session; //!<会话。
    void ListArticles(); //!<列出资金流水。
}; //class StoreListWidget : public WContainerWidget

#endif // FINANCEFLOWLISTWIDGET_H
