#include <Wt/Dbo/Session> //Session

#include "SBlogPreCompile.h" //Session.

#include "SBlog.h" //SBlog

#include "SbDbComment.h" //SbDbComment

/*!
  *@brief 构造函数，指定亲代部件。
  */
SBlog::SBlog(WContainerWidget *Parent):WContainerWidget(Parent),sqlite3("host=127.0.0.1 user=postgres password=postgres port=5432 dbname=HongKongLunch")
{
    session.setConnection(sqlite3); //连接。

    session.mapClass<SbDbAuthor>("sbdbauthor"); //映射数据表，作者。
    session.mapClass<SbDbTag>("sbdbtag"); //映射数据表，标记。
    session.mapClass<SbDbCategory>("sbdbcategory"); //映射数据表，分类。
    session.mapClass<SbDbItem>("sbdbitem"); //映射文章表。
    session.mapClass<SbDbComment>("sbdbcomment"); //映射评论表。


    setStyleClass("P2pWebContainer"); //设置样式类。

    srand(time(0)); //初始化随机数生成器。

    //默认是未登陆状态：
    LoggedIn=false; //未登录。

    setupUi(); //setup the ui.


} //GenieProWeb::GenieProWeb(WContainerWidget *Parent):WTabWidget(Parent)

/*!
  *@brief 处理登陆事项。
  */
void SBlog::DoLogin()
{
    WApplication * CurApplication=WApplication::instance(); //获取当前程序的实例。

    if (!LoggedIn) //还没有用户登陆成功。
    {
        CurApplication->setTitle(WString::tr("QueueMate Management System:login")); //设置网页标题。


        hide(); //隐藏。
    } //if
} //void     GenieProWeb::DoLogin()



/*!
  *@brief 析构函数。
  */
SBlog::~SBlog()
{
    delete Tabs; //Delete the tabs.
} //GenieProWeb::~GenieProWeb()



/*!
  *@brief 做退出处理。
  */
void SBlog::Logout()
{
    LoggedIn=false; //未登录。

    DoLogin(); //要求登录。

    return;
} //void GenieProWeb::Logout()

/*!
  *@brief 设置内部路径为根路径。
  */
void SBlog::SetPathRoot()
{
    WApplication::instance()->setInternalPath("/"); //设置内部路径。

    return;
} //void GenieProWeb::SetPathRoot()

/*!
  *@brief 跳转到文件管理页面。
  */
void SBlog::GotoFileManage()
{
    Tabs->setCurrentWidget(StorMngTab); //切换到文件管理页面。

    return;
} //void P2pWeb::GotoFileManage()

/*!
 * \brief P2pWeb::SetApp 设置应用程序实例。
 * \param this2St 要设置的应用程序实例。
 */
void SBlog::SetApp(WApplication * this2St)
{
    app=this2St; //记录。

    return;
} //void P2pWeb::SetApp(WApplication * this2St) //!<设置应用程序实例。


/*!
 *  刷新事件。
 */
void SBlog::refresh()
{
    qDebug() << __FILE__ << __LINE__ << __func__; //Debug.
    
    StorMngTab->refresh(); //刷新店铺管理页面。
} //void QueueMateWeb::refresh() //!<刷新事件。

/*!
 * \brief QueueMateWeb::setupUi setup the ui.
 */
void SBlog::setupUi()
{
    WLabel * titleLabel=new WLabel(WString::tr("StupidBeauty")); //the blog title .
    titleLabel->setStyleClass ("blogtitle"); //set the style class.
    addWidget (titleLabel); //Add the title label.

    //构建各个标签，并且添加到界面上：
    //一个大厅标签页，一个用户信息标签页，一个个的业务标签页：

    Tabs=new WTabWidget(this); //创建标签部件。
    Tabs->setStyleClass("P2pWebTab"); //设置样式类。
    Tabs->contentsStack()->setStyleClass("P2pWebTabStack"); //设置样式类。
    Tabs->contentsStack()->setTransitionAnimation(WAnimation(WAnimation::SlideInFromRight),true); //动画切换。

    //店铺管理标签：
    StorMngTab=new StoreManageTabWidget(&session); //创建财务管理标签页。
    Tabs->addTab(StorMngTab,WString::tr("Store Manage")); //Store管理标签页。

    //利益分配标签：

    Tabs->setCurrentWidget (StorMngTab); //Set the current page to store management.


    //放在菜单栏后面作为背景的标签：
    WLabel * BgLbl=new WLabel(this);
    BgLbl->show(); //显示。
    BgLbl->setStyleClass("NavBg"); //导航条的背景。

    return;
} //void QueueMateWeb::setupUi()
